// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.Transition
import aws.sdk.kotlin.services.s3control.model.TransitionStorageClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeTransitionDocument(reader: XmlTagReader): Transition {
    val builder = Transition.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Date com.amazonaws.s3control#Transition$Date
            "Date" -> builder.date = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#Date`)" }
            // Days com.amazonaws.s3control#Transition$Days
            "Days" -> builder.days = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3control#Days`)" }
            // StorageClass com.amazonaws.s3control#Transition$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { TransitionStorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#TransitionStorageClass`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
