// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointReport
import aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeMultiRegionAccessPointReportDocument(reader: XmlTagReader): MultiRegionAccessPointReport {
    val builder = MultiRegionAccessPointReport.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Name com.amazonaws.s3control#MultiRegionAccessPointReport$Name
            "Name" -> builder.name = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#MultiRegionAccessPointName`)" }
            // Alias com.amazonaws.s3control#MultiRegionAccessPointReport$Alias
            "Alias" -> builder.alias = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#MultiRegionAccessPointAlias`)" }
            // CreatedAt com.amazonaws.s3control#MultiRegionAccessPointReport$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)" }
            // PublicAccessBlock com.amazonaws.s3control#MultiRegionAccessPointReport$PublicAccessBlock
            "PublicAccessBlock" -> builder.publicAccessBlock = deserializePublicAccessBlockConfigurationDocument(curr)
            // Status com.amazonaws.s3control#MultiRegionAccessPointReport$Status
            "Status" -> builder.status = curr.tryData()
                .parse { MultiRegionAccessPointStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#MultiRegionAccessPointStatus`)" }
            // Regions com.amazonaws.s3control#MultiRegionAccessPointReport$Regions
            "Regions" -> builder.regions = deserializeRegionReportListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
