// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstanceEntry
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstancesResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListAccessGrantsInstancesOperationDeserializer: HttpDeserializer.NonStreaming<ListAccessGrantsInstancesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListAccessGrantsInstancesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAccessGrantsInstancesError(context, call, payload)
        }
        val builder = ListAccessGrantsInstancesResponse.Builder()

        if (payload != null) {
            deserializeListAccessGrantsInstancesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListAccessGrantsInstancesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAccessGrantsInstancesOperationBody(builder: ListAccessGrantsInstancesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessGrantsInstancesList com.amazonaws.s3control#ListAccessGrantsInstancesResult$AccessGrantsInstancesList
            "AccessGrantsInstancesList" -> builder.accessGrantsInstancesList = deserializeAccessGrantsInstancesListShape(curr)
            // NextToken com.amazonaws.s3control#ListAccessGrantsInstancesResult$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ContinuationToken`)" }
            else -> {}
        }
        curr.drop()
    }
}
