// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.ListAccessGrantEntry
import aws.sdk.kotlin.services.s3control.model.Permission
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeListAccessGrantEntryDocument(reader: XmlTagReader): ListAccessGrantEntry {
    val builder = ListAccessGrantEntry.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CreatedAt com.amazonaws.s3control#ListAccessGrantEntry$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)" }
            // AccessGrantId com.amazonaws.s3control#ListAccessGrantEntry$AccessGrantId
            "AccessGrantId" -> builder.accessGrantId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantId`)" }
            // AccessGrantArn com.amazonaws.s3control#ListAccessGrantEntry$AccessGrantArn
            "AccessGrantArn" -> builder.accessGrantArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantArn`)" }
            // Grantee com.amazonaws.s3control#ListAccessGrantEntry$Grantee
            "Grantee" -> builder.grantee = deserializeGranteeDocument(curr)
            // Permission com.amazonaws.s3control#ListAccessGrantEntry$Permission
            "Permission" -> builder.permission = curr.tryData()
                .parse { Permission.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#Permission`)" }
            // AccessGrantsLocationId com.amazonaws.s3control#ListAccessGrantEntry$AccessGrantsLocationId
            "AccessGrantsLocationId" -> builder.accessGrantsLocationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsLocationId`)" }
            // AccessGrantsLocationConfiguration com.amazonaws.s3control#ListAccessGrantEntry$AccessGrantsLocationConfiguration
            "AccessGrantsLocationConfiguration" -> builder.accessGrantsLocationConfiguration = deserializeAccessGrantsLocationConfigurationDocument(curr)
            // GrantScope com.amazonaws.s3control#ListAccessGrantEntry$GrantScope
            "GrantScope" -> builder.grantScope = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3Prefix`)" }
            // ApplicationArn com.amazonaws.s3control#ListAccessGrantEntry$ApplicationArn
            "ApplicationArn" -> builder.applicationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#IdentityCenterApplicationArn`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
