// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusResponse
import aws.sdk.kotlin.services.s3control.model.PolicyStatus
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetAccessPointPolicyStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetAccessPointPolicyStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAccessPointPolicyStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccessPointPolicyStatusError(context, call, payload)
        }
        val builder = GetAccessPointPolicyStatusResponse.Builder()

        if (payload != null) {
            deserializeGetAccessPointPolicyStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAccessPointPolicyStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessPointPolicyStatusOperationBody(builder: GetAccessPointPolicyStatusResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // PolicyStatus com.amazonaws.s3control#GetAccessPointPolicyStatusResult$PolicyStatus
            "PolicyStatus" -> builder.policyStatus = deserializePolicyStatusDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
