// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.NetworkOrigin
import aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.sdk.kotlin.services.s3control.model.VpcConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetAccessPointOperationDeserializer: HttpDeserializer.NonStreaming<GetAccessPointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAccessPointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccessPointError(context, call, payload)
        }
        val builder = GetAccessPointResponse.Builder()

        if (payload != null) {
            deserializeGetAccessPointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAccessPointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessPointOperationBody(builder: GetAccessPointResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessPointArn com.amazonaws.s3control#GetAccessPointResult$AccessPointArn
            "AccessPointArn" -> builder.accessPointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3AccessPointArn`)" }
            // Alias com.amazonaws.s3control#GetAccessPointResult$Alias
            "Alias" -> builder.alias = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#Alias`)" }
            // Bucket com.amazonaws.s3control#GetAccessPointResult$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#BucketName`)" }
            // BucketAccountId com.amazonaws.s3control#GetAccessPointResult$BucketAccountId
            "BucketAccountId" -> builder.bucketAccountId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccountId`)" }
            // CreationDate com.amazonaws.s3control#GetAccessPointResult$CreationDate
            "CreationDate" -> builder.creationDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationDate`)" }
            // Endpoints com.amazonaws.s3control#GetAccessPointResult$Endpoints
            "Endpoints" -> builder.endpoints = deserializeEndpointsShape(curr)
            // Name com.amazonaws.s3control#GetAccessPointResult$Name
            "Name" -> builder.name = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessPointName`)" }
            // NetworkOrigin com.amazonaws.s3control#GetAccessPointResult$NetworkOrigin
            "NetworkOrigin" -> builder.networkOrigin = curr.tryData()
                .parse { NetworkOrigin.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#NetworkOrigin`)" }
            // PublicAccessBlockConfiguration com.amazonaws.s3control#GetAccessPointResult$PublicAccessBlockConfiguration
            "PublicAccessBlockConfiguration" -> builder.publicAccessBlockConfiguration = deserializePublicAccessBlockConfigurationDocument(curr)
            // VpcConfiguration com.amazonaws.s3control#GetAccessPointResult$VpcConfiguration
            "VpcConfiguration" -> builder.vpcConfiguration = deserializeVpcConfigurationDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
