// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration
import aws.sdk.kotlin.services.s3control.model.VpcConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAccessPointOperationSerializer: HttpSerializer.NonStreaming<CreateAccessPointRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAccessPointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.name) { "name is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20180820"))
                add(PercentEncoding.Path.encode("accesspoint"))
                add(PercentEncoding.SmithyLabel.encode("${input.name}"))
            }
        }

        builder.headers {
            if (input.accountId?.isNotEmpty() == true) append("x-amz-account-id", input.accountId)
        }

        val payload = serializeCreateAccessPointOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeCreateAccessPointOperationBody(context: ExecutionContext, input: CreateAccessPointRequest): ByteArray {
    val serializer = XmlSerializer()
    val BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Bucket"))
    val BUCKETACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("BucketAccountId"))
    val PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PublicAccessBlockConfiguration"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("VpcConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateAccessPointRequest"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(BUCKET_DESCRIPTOR)
        field(BUCKETACCOUNTID_DESCRIPTOR)
        field(PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.bucket?.let { field(BUCKET_DESCRIPTOR, it) }
        input.bucketAccountId?.let { field(BUCKETACCOUNTID_DESCRIPTOR, it) }
        input.publicAccessBlockConfiguration?.let { field(PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR, it, ::serializePublicAccessBlockConfigurationDocument) }
        input.vpcConfiguration?.let { field(VPCCONFIGURATION_DESCRIPTOR, it, ::serializeVpcConfigurationDocument) }
    }
    return serializer.toByteArray()
}
