// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsInstanceResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateAccessGrantsInstanceOperationDeserializer: HttpDeserializer.NonStreaming<CreateAccessGrantsInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAccessGrantsInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAccessGrantsInstanceError(context, call, payload)
        }
        val builder = CreateAccessGrantsInstanceResponse.Builder()

        if (payload != null) {
            deserializeCreateAccessGrantsInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAccessGrantsInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAccessGrantsInstanceOperationBody(builder: CreateAccessGrantsInstanceResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessGrantsInstanceArn com.amazonaws.s3control#CreateAccessGrantsInstanceResult$AccessGrantsInstanceArn
            "AccessGrantsInstanceArn" -> builder.accessGrantsInstanceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsInstanceArn`)" }
            // AccessGrantsInstanceId com.amazonaws.s3control#CreateAccessGrantsInstanceResult$AccessGrantsInstanceId
            "AccessGrantsInstanceId" -> builder.accessGrantsInstanceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsInstanceId`)" }
            // CreatedAt com.amazonaws.s3control#CreateAccessGrantsInstanceResult$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)" }
            // IdentityCenterArn com.amazonaws.s3control#CreateAccessGrantsInstanceResult$IdentityCenterArn
            "IdentityCenterArn" -> builder.identityCenterArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#IdentityCenterArn`)" }
            else -> {}
        }
        curr.drop()
    }
}
