// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.AsyncOperation
import aws.sdk.kotlin.services.s3control.model.AsyncOperationName
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeAsyncOperationDocument(reader: XmlTagReader): AsyncOperation {
    val builder = AsyncOperation.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CreationTime com.amazonaws.s3control#AsyncOperation$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#AsyncCreationTimestamp`)" }
            // Operation com.amazonaws.s3control#AsyncOperation$Operation
            "Operation" -> builder.operation = curr.tryData()
                .parse { AsyncOperationName.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#AsyncOperationName`)" }
            // RequestTokenARN com.amazonaws.s3control#AsyncOperation$RequestTokenARN
            "RequestTokenARN" -> builder.requestTokenArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AsyncRequestTokenARN`)" }
            // RequestParameters com.amazonaws.s3control#AsyncOperation$RequestParameters
            "RequestParameters" -> builder.requestParameters = deserializeAsyncRequestParametersDocument(curr)
            // RequestStatus com.amazonaws.s3control#AsyncOperation$RequestStatus
            "RequestStatus" -> builder.requestStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AsyncRequestStatus`)" }
            // ResponseDetails com.amazonaws.s3control#AsyncOperation$ResponseDetails
            "ResponseDetails" -> builder.responseDetails = deserializeAsyncResponseDetailsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
