// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container for the noncurrent version transition.
 */
public class NoncurrentVersionTransition private constructor(builder: Builder) {
    /**
     * Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see [ How Amazon S3 Calculates How Long an Object Has Been Noncurrent](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations) in the *Amazon S3 User Guide*.
     */
    public val noncurrentDays: kotlin.Int = builder.noncurrentDays
    /**
     * The class of storage used to store the object.
     */
    public val storageClass: aws.sdk.kotlin.services.s3control.model.TransitionStorageClass? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.NoncurrentVersionTransition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NoncurrentVersionTransition(")
        append("noncurrentDays=$noncurrentDays,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = noncurrentDays
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NoncurrentVersionTransition

        if (noncurrentDays != other.noncurrentDays) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.NoncurrentVersionTransition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see [ How Amazon S3 Calculates How Long an Object Has Been Noncurrent](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations) in the *Amazon S3 User Guide*.
         */
        public var noncurrentDays: kotlin.Int = 0
        /**
         * The class of storage used to store the object.
         */
        public var storageClass: aws.sdk.kotlin.services.s3control.model.TransitionStorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionTransition) : this() {
            this.noncurrentDays = x.noncurrentDays
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.NoncurrentVersionTransition = NoncurrentVersionTransition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
