// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAccessGrantsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that is making this request.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The S3 path of the data to which you are granting access. It is the result of appending the `Subprefix` to the location scope.
     */
    public val grantScope: kotlin.String? = builder.grantScope
    /**
     * The unique identifer of the `Grantee`. If the grantee type is `IAM`, the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`. You can obtain this UUID from your Amazon Web Services IAM Identity Center instance.
     */
    public val granteeIdentifier: kotlin.String? = builder.granteeIdentifier
    /**
     * The type of the grantee to which access has been granted. It can be one of the following values:
     * + `IAM` - An IAM user or role.
     * + `DIRECTORY_USER` - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
     * + `DIRECTORY_GROUP` - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
     */
    public val granteeType: aws.sdk.kotlin.services.s3control.model.GranteeType? = builder.granteeType
    /**
     * The maximum number of access grants that you would like returned in the `List Access Grants` response. If the results include the pagination token `NextToken`, make another call using the `NextToken` to determine if there are more results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A pagination token to request the next page of results. Pass this value into a subsequent `List Access Grants` request in order to retrieve the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of permission granted to your S3 data, which can be set to one of the following values:
     * + `READ` – Grant read-only access to the S3 data.
     * + `WRITE` – Grant write-only access to the S3 data.
     * + `READWRITE` – Grant both read and write access to the S3 data.
     */
    public val permission: aws.sdk.kotlin.services.s3control.model.Permission? = builder.permission

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAccessGrantsRequest(")
        append("accountId=$accountId,")
        append("applicationArn=$applicationArn,")
        append("grantScope=$grantScope,")
        append("granteeIdentifier=$granteeIdentifier,")
        append("granteeType=$granteeType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("permission=$permission")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (applicationArn?.hashCode() ?: 0)
        result = 31 * result + (grantScope?.hashCode() ?: 0)
        result = 31 * result + (granteeIdentifier?.hashCode() ?: 0)
        result = 31 * result + (granteeType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAccessGrantsRequest

        if (accountId != other.accountId) return false
        if (applicationArn != other.applicationArn) return false
        if (grantScope != other.grantScope) return false
        if (granteeIdentifier != other.granteeIdentifier) return false
        if (granteeType != other.granteeType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (permission != other.permission) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that is making this request.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The S3 path of the data to which you are granting access. It is the result of appending the `Subprefix` to the location scope.
         */
        public var grantScope: kotlin.String? = null
        /**
         * The unique identifer of the `Grantee`. If the grantee type is `IAM`, the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`. You can obtain this UUID from your Amazon Web Services IAM Identity Center instance.
         */
        public var granteeIdentifier: kotlin.String? = null
        /**
         * The type of the grantee to which access has been granted. It can be one of the following values:
         * + `IAM` - An IAM user or role.
         * + `DIRECTORY_USER` - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
         * + `DIRECTORY_GROUP` - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
         */
        public var granteeType: aws.sdk.kotlin.services.s3control.model.GranteeType? = null
        /**
         * The maximum number of access grants that you would like returned in the `List Access Grants` response. If the results include the pagination token `NextToken`, make another call using the `NextToken` to determine if there are more results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A pagination token to request the next page of results. Pass this value into a subsequent `List Access Grants` request in order to retrieve the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of permission granted to your S3 data, which can be set to one of the following values:
         * + `READ` – Grant read-only access to the S3 data.
         * + `WRITE` – Grant write-only access to the S3 data.
         * + `READWRITE` – Grant both read and write access to the S3 data.
         */
        public var permission: aws.sdk.kotlin.services.s3control.model.Permission? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest) : this() {
            this.accountId = x.accountId
            this.applicationArn = x.applicationArn
            this.grantScope = x.grantScope
            this.granteeIdentifier = x.granteeIdentifier
            this.granteeType = x.granteeType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.permission = x.permission
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest = ListAccessGrantsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
