// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container for the Outposts bucket lifecycle rule.
 */
public class LifecycleRule private constructor(builder: Builder) {
    /**
     * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see [ Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
     */
    public val abortIncompleteMultipartUpload: aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload? = builder.abortIncompleteMultipartUpload
    /**
     * Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.
     */
    public val expiration: aws.sdk.kotlin.services.s3control.model.LifecycleExpiration? = builder.expiration
    /**
     * The container for the filter of lifecycle rule.
     */
    public val filter: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter? = builder.filter
    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The noncurrent version expiration of the lifecycle rule.
     */
    public val noncurrentVersionExpiration: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration? = builder.noncurrentVersionExpiration
    /**
     * Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val noncurrentVersionTransitions: List<NoncurrentVersionTransition>? = builder.noncurrentVersionTransitions
    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.ExpirationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Specifies when an Amazon S3 object transitions to a specified storage class.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val transitions: List<Transition>? = builder.transitions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.LifecycleRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleRule(")
        append("abortIncompleteMultipartUpload=$abortIncompleteMultipartUpload,")
        append("expiration=$expiration,")
        append("filter=$filter,")
        append("id=$id,")
        append("noncurrentVersionExpiration=$noncurrentVersionExpiration,")
        append("noncurrentVersionTransitions=$noncurrentVersionTransitions,")
        append("status=$status,")
        append("transitions=$transitions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortIncompleteMultipartUpload?.hashCode() ?: 0
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionExpiration?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionTransitions?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (transitions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleRule

        if (abortIncompleteMultipartUpload != other.abortIncompleteMultipartUpload) return false
        if (expiration != other.expiration) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (noncurrentVersionExpiration != other.noncurrentVersionExpiration) return false
        if (noncurrentVersionTransitions != other.noncurrentVersionTransitions) return false
        if (status != other.status) return false
        if (transitions != other.transitions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.LifecycleRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see [ Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
         */
        public var abortIncompleteMultipartUpload: aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload? = null
        /**
         * Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.
         */
        public var expiration: aws.sdk.kotlin.services.s3control.model.LifecycleExpiration? = null
        /**
         * The container for the filter of lifecycle rule.
         */
        public var filter: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter? = null
        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         */
        public var id: kotlin.String? = null
        /**
         * The noncurrent version expiration of the lifecycle rule.
         */
        public var noncurrentVersionExpiration: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration? = null
        /**
         * Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var noncurrentVersionTransitions: List<NoncurrentVersionTransition>? = null
        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.ExpirationStatus? = null
        /**
         * Specifies when an Amazon S3 object transitions to a specified storage class.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var transitions: List<Transition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.LifecycleRule) : this() {
            this.abortIncompleteMultipartUpload = x.abortIncompleteMultipartUpload
            this.expiration = x.expiration
            this.filter = x.filter
            this.id = x.id
            this.noncurrentVersionExpiration = x.noncurrentVersionExpiration
            this.noncurrentVersionTransitions = x.noncurrentVersionTransitions
            this.status = x.status
            this.transitions = x.transitions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.LifecycleRule = LifecycleRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload] inside the given [block]
         */
        public fun abortIncompleteMultipartUpload(block: aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload.Builder.() -> kotlin.Unit) {
            this.abortIncompleteMultipartUpload = aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.LifecycleExpiration] inside the given [block]
         */
        public fun expiration(block: aws.sdk.kotlin.services.s3control.model.LifecycleExpiration.Builder.() -> kotlin.Unit) {
            this.expiration = aws.sdk.kotlin.services.s3control.model.LifecycleExpiration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration] inside the given [block]
         */
        public fun noncurrentVersionExpiration(block: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration.Builder.() -> kotlin.Unit) {
            this.noncurrentVersionExpiration = aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (status == null) status = ExpirationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
