// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata
import aws.sdk.kotlin.services.s3control.model.S3SseAlgorithm
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeS3ObjectMetadataDocument(reader: XmlTagReader): S3ObjectMetadata {
    val builder = S3ObjectMetadata.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheControl com.amazonaws.s3control#S3ObjectMetadata$CacheControl
            "CacheControl" -> builder.cacheControl = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // ContentDisposition com.amazonaws.s3control#S3ObjectMetadata$ContentDisposition
            "ContentDisposition" -> builder.contentDisposition = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // ContentEncoding com.amazonaws.s3control#S3ObjectMetadata$ContentEncoding
            "ContentEncoding" -> builder.contentEncoding = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // ContentLanguage com.amazonaws.s3control#S3ObjectMetadata$ContentLanguage
            "ContentLanguage" -> builder.contentLanguage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // UserMetadata com.amazonaws.s3control#S3ObjectMetadata$UserMetadata
            "UserMetadata" -> builder.userMetadata = deserializeS3UserMetadataShape(curr)
            // ContentLength com.amazonaws.s3control#S3ObjectMetadata$ContentLength
            "ContentLength" -> builder.contentLength = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.s3control#S3ContentLength`)" }
            // ContentMD5 com.amazonaws.s3control#S3ObjectMetadata$ContentMD5
            "ContentMD5" -> builder.contentMd5 = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // ContentType com.amazonaws.s3control#S3ObjectMetadata$ContentType
            "ContentType" -> builder.contentType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // HttpExpiresDate com.amazonaws.s3control#S3ObjectMetadata$HttpExpiresDate
            "HttpExpiresDate" -> builder.httpExpiresDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#TimeStamp`)" }
            // RequesterCharged com.amazonaws.s3control#S3ObjectMetadata$RequesterCharged
            "RequesterCharged" -> builder.requesterCharged = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#Boolean`)" }
            // SSEAlgorithm com.amazonaws.s3control#S3ObjectMetadata$SSEAlgorithm
            "SSEAlgorithm" -> builder.sseAlgorithm = curr.tryData()
                .parse { S3SseAlgorithm.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3SSEAlgorithm`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
