// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.Format
import aws.sdk.kotlin.services.s3control.model.OutputSchemaVersion
import aws.sdk.kotlin.services.s3control.model.S3BucketDestination
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeS3BucketDestinationDocument(reader: XmlTagReader): S3BucketDestination {
    val builder = S3BucketDestination.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Format com.amazonaws.s3control#S3BucketDestination$Format
            "Format" -> builder.format = curr.tryData()
                .parse { Format.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#Format`)" }
            // OutputSchemaVersion com.amazonaws.s3control#S3BucketDestination$OutputSchemaVersion
            "OutputSchemaVersion" -> builder.outputSchemaVersion = curr.tryData()
                .parse { OutputSchemaVersion.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#OutputSchemaVersion`)" }
            // AccountId com.amazonaws.s3control#S3BucketDestination$AccountId
            "AccountId" -> builder.accountId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccountId`)" }
            // Arn com.amazonaws.s3control#S3BucketDestination$Arn
            "Arn" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3BucketArnString`)" }
            // Prefix com.amazonaws.s3control#S3BucketDestination$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#Prefix`)" }
            // Encryption com.amazonaws.s3control#S3BucketDestination$Encryption
            "Encryption" -> builder.encryption = deserializeStorageLensDataExportEncryptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
