// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.RegionalBucket
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeRegionalBucketDocument(reader: XmlTagReader): RegionalBucket {
    val builder = RegionalBucket.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Bucket com.amazonaws.s3control#RegionalBucket$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#BucketName`)" }
            // BucketArn com.amazonaws.s3control#RegionalBucket$BucketArn
            "BucketArn" -> builder.bucketArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3RegionalBucketArn`)" }
            // PublicAccessBlockEnabled com.amazonaws.s3control#RegionalBucket$PublicAccessBlockEnabled
            "PublicAccessBlockEnabled" -> builder.publicAccessBlockEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#PublicAccessBlockEnabled`)" }
            // CreationDate com.amazonaws.s3control#RegionalBucket$CreationDate
            "CreationDate" -> builder.creationDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationDate`)" }
            // OutpostId com.amazonaws.s3control#RegionalBucket$OutpostId
            "OutpostId" -> builder.outpostId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength64String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
