// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.ExpirationStatus
import aws.sdk.kotlin.services.s3control.model.LifecycleRule
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeLifecycleRuleDocument(reader: XmlTagReader): LifecycleRule {
    val builder = LifecycleRule.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Expiration com.amazonaws.s3control#LifecycleRule$Expiration
            "Expiration" -> builder.expiration = deserializeLifecycleExpirationDocument(curr)
            // ID com.amazonaws.s3control#LifecycleRule$ID
            "ID" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ID`)" }
            // Filter com.amazonaws.s3control#LifecycleRule$Filter
            "Filter" -> builder.filter = deserializeLifecycleRuleFilterDocument(curr)
            // Status com.amazonaws.s3control#LifecycleRule$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ExpirationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#ExpirationStatus`)" }
            // Transitions com.amazonaws.s3control#LifecycleRule$Transitions
            "Transitions" -> builder.transitions = deserializeTransitionListShape(curr)
            // NoncurrentVersionTransitions com.amazonaws.s3control#LifecycleRule$NoncurrentVersionTransitions
            "NoncurrentVersionTransitions" -> builder.noncurrentVersionTransitions = deserializeNoncurrentVersionTransitionListShape(curr)
            // NoncurrentVersionExpiration com.amazonaws.s3control#LifecycleRule$NoncurrentVersionExpiration
            "NoncurrentVersionExpiration" -> builder.noncurrentVersionExpiration = deserializeNoncurrentVersionExpirationDocument(curr)
            // AbortIncompleteMultipartUpload com.amazonaws.s3control#LifecycleRule$AbortIncompleteMultipartUpload
            "AbortIncompleteMultipartUpload" -> builder.abortIncompleteMultipartUpload = deserializeAbortIncompleteMultipartUploadDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
