// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.JobListDescriptor
import aws.sdk.kotlin.services.s3control.model.JobStatus
import aws.sdk.kotlin.services.s3control.model.OperationName
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeJobListDescriptorDocument(reader: XmlTagReader): JobListDescriptor {
    val builder = JobListDescriptor.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // JobId com.amazonaws.s3control#JobListDescriptor$JobId
            "JobId" -> builder.jobId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#JobId`)" }
            // Description com.amazonaws.s3control#JobListDescriptor$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength256String`)" }
            // Operation com.amazonaws.s3control#JobListDescriptor$Operation
            "Operation" -> builder.operation = curr.tryData()
                .parse { OperationName.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#OperationName`)" }
            // Priority com.amazonaws.s3control#JobListDescriptor$Priority
            "Priority" -> builder.priority = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3control#JobPriority`)" }
            // Status com.amazonaws.s3control#JobListDescriptor$Status
            "Status" -> builder.status = curr.tryData()
                .parse { JobStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#JobStatus`)" }
            // CreationTime com.amazonaws.s3control#JobListDescriptor$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#JobCreationTime`)" }
            // TerminationDate com.amazonaws.s3control#JobListDescriptor$TerminationDate
            "TerminationDate" -> builder.terminationDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#JobTerminationDate`)" }
            // ProgressSummary com.amazonaws.s3control#JobListDescriptor$ProgressSummary
            "ProgressSummary" -> builder.progressSummary = deserializeJobProgressSummaryDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
