// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.JobDescriptor
import aws.sdk.kotlin.services.s3control.model.JobStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeJobDescriptorDocument(reader: XmlTagReader): JobDescriptor {
    val builder = JobDescriptor.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // JobId com.amazonaws.s3control#JobDescriptor$JobId
            "JobId" -> builder.jobId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#JobId`)" }
            // ConfirmationRequired com.amazonaws.s3control#JobDescriptor$ConfirmationRequired
            "ConfirmationRequired" -> builder.confirmationRequired = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#ConfirmationRequired`)" }
            // Description com.amazonaws.s3control#JobDescriptor$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength256String`)" }
            // JobArn com.amazonaws.s3control#JobDescriptor$JobArn
            "JobArn" -> builder.jobArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#JobArn`)" }
            // Status com.amazonaws.s3control#JobDescriptor$Status
            "Status" -> builder.status = curr.tryData()
                .parse { JobStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#JobStatus`)" }
            // Manifest com.amazonaws.s3control#JobDescriptor$Manifest
            "Manifest" -> builder.manifest = deserializeJobManifestDocument(curr)
            // Operation com.amazonaws.s3control#JobDescriptor$Operation
            "Operation" -> builder.operation = deserializeJobOperationDocument(curr)
            // Priority com.amazonaws.s3control#JobDescriptor$Priority
            "Priority" -> builder.priority = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3control#JobPriority`)" }
            // ProgressSummary com.amazonaws.s3control#JobDescriptor$ProgressSummary
            "ProgressSummary" -> builder.progressSummary = deserializeJobProgressSummaryDocument(curr)
            // StatusUpdateReason com.amazonaws.s3control#JobDescriptor$StatusUpdateReason
            "StatusUpdateReason" -> builder.statusUpdateReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#JobStatusUpdateReason`)" }
            // FailureReasons com.amazonaws.s3control#JobDescriptor$FailureReasons
            "FailureReasons" -> builder.failureReasons = deserializeJobFailureListShape(curr)
            // Report com.amazonaws.s3control#JobDescriptor$Report
            "Report" -> builder.report = deserializeJobReportDocument(curr)
            // CreationTime com.amazonaws.s3control#JobDescriptor$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#JobCreationTime`)" }
            // TerminationDate com.amazonaws.s3control#JobDescriptor$TerminationDate
            "TerminationDate" -> builder.terminationDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#JobTerminationDate`)" }
            // RoleArn com.amazonaws.s3control#JobDescriptor$RoleArn
            "RoleArn" -> builder.roleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#IAMRoleArn`)" }
            // SuspendedDate com.amazonaws.s3control#JobDescriptor$SuspendedDate
            "SuspendedDate" -> builder.suspendedDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#SuspendedDate`)" }
            // SuspendedCause com.amazonaws.s3control#JobDescriptor$SuspendedCause
            "SuspendedCause" -> builder.suspendedCause = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#SuspendedCause`)" }
            // ManifestGenerator com.amazonaws.s3control#JobDescriptor$ManifestGenerator
            "ManifestGenerator" -> builder.manifestGenerator = deserializeJobManifestGeneratorDocument(curr)
            // GeneratedManifestDescriptor com.amazonaws.s3control#JobDescriptor$GeneratedManifestDescriptor
            "GeneratedManifestDescriptor" -> builder.generatedManifestDescriptor = deserializeS3GeneratedManifestDescriptorDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
