// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.BucketVersioningStatus
import aws.sdk.kotlin.services.s3control.model.GetBucketVersioningResponse
import aws.sdk.kotlin.services.s3control.model.MfaDeleteStatus
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetBucketVersioningOperationDeserializer: HttpDeserializer.NonStreaming<GetBucketVersioningResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBucketVersioningResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBucketVersioningError(context, call, payload)
        }
        val builder = GetBucketVersioningResponse.Builder()

        if (payload != null) {
            deserializeGetBucketVersioningOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBucketVersioningError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketVersioningOperationBody(builder: GetBucketVersioningResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // MFADelete com.amazonaws.s3control#GetBucketVersioningResult$MFADelete
            "MfaDelete" -> builder.mfaDelete = curr.tryData()
                .parse { MfaDeleteStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#MFADeleteStatus`)" }
            // Status com.amazonaws.s3control#GetBucketVersioningResult$Status
            "Status" -> builder.status = curr.tryData()
                .parse { BucketVersioningStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#BucketVersioningStatus`)" }
            else -> {}
        }
        curr.drop()
    }
}
