// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.GetAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ObjectLambdaAccessPointAlias
import aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetAccessPointForObjectLambdaOperationDeserializer: HttpDeserializer.NonStreaming<GetAccessPointForObjectLambdaResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAccessPointForObjectLambdaResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccessPointForObjectLambdaError(context, call, payload)
        }
        val builder = GetAccessPointForObjectLambdaResponse.Builder()

        if (payload != null) {
            deserializeGetAccessPointForObjectLambdaOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAccessPointForObjectLambdaError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessPointForObjectLambdaOperationBody(builder: GetAccessPointForObjectLambdaResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Alias com.amazonaws.s3control#GetAccessPointForObjectLambdaResult$Alias
            "Alias" -> builder.alias = deserializeObjectLambdaAccessPointAliasDocument(curr)
            // CreationDate com.amazonaws.s3control#GetAccessPointForObjectLambdaResult$CreationDate
            "CreationDate" -> builder.creationDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationDate`)" }
            // Name com.amazonaws.s3control#GetAccessPointForObjectLambdaResult$Name
            "Name" -> builder.name = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ObjectLambdaAccessPointName`)" }
            // PublicAccessBlockConfiguration com.amazonaws.s3control#GetAccessPointForObjectLambdaResult$PublicAccessBlockConfiguration
            "PublicAccessBlockConfiguration" -> builder.publicAccessBlockConfiguration = deserializePublicAccessBlockConfigurationDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
