// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.Destination
import aws.sdk.kotlin.services.s3control.model.ReplicationStorageClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeDestinationDocument(reader: XmlTagReader): Destination {
    val builder = Destination.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Account com.amazonaws.s3control#Destination$Account
            "Account" -> builder.account = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccountId`)" }
            // Bucket com.amazonaws.s3control#Destination$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#BucketIdentifierString`)" }
            // ReplicationTime com.amazonaws.s3control#Destination$ReplicationTime
            "ReplicationTime" -> builder.replicationTime = deserializeReplicationTimeDocument(curr)
            // AccessControlTranslation com.amazonaws.s3control#Destination$AccessControlTranslation
            "AccessControlTranslation" -> builder.accessControlTranslation = deserializeAccessControlTranslationDocument(curr)
            // EncryptionConfiguration com.amazonaws.s3control#Destination$EncryptionConfiguration
            "EncryptionConfiguration" -> builder.encryptionConfiguration = deserializeEncryptionConfigurationDocument(curr)
            // Metrics com.amazonaws.s3control#Destination$Metrics
            "Metrics" -> builder.metrics = deserializeMetricsDocument(curr)
            // StorageClass com.amazonaws.s3control#Destination$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { ReplicationStorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#ReplicationStorageClass`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
