// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.CreateAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ObjectLambdaAccessPointAlias
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateAccessPointForObjectLambdaOperationDeserializer: HttpDeserializer.NonStreaming<CreateAccessPointForObjectLambdaResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAccessPointForObjectLambdaResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAccessPointForObjectLambdaError(context, call, payload)
        }
        val builder = CreateAccessPointForObjectLambdaResponse.Builder()

        if (payload != null) {
            deserializeCreateAccessPointForObjectLambdaOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAccessPointForObjectLambdaError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAccessPointForObjectLambdaOperationBody(builder: CreateAccessPointForObjectLambdaResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Alias com.amazonaws.s3control#CreateAccessPointForObjectLambdaResult$Alias
            "Alias" -> builder.alias = deserializeObjectLambdaAccessPointAliasDocument(curr)
            // ObjectLambdaAccessPointArn com.amazonaws.s3control#CreateAccessPointForObjectLambdaResult$ObjectLambdaAccessPointArn
            "ObjectLambdaAccessPointArn" -> builder.objectLambdaAccessPointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ObjectLambdaAccessPointArn`)" }
            else -> {}
        }
        curr.drop()
    }
}
