// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A Region that supports a Multi-Region Access Point as well as the associated bucket for the Region.
 */
public class Region private constructor(builder: Builder) {
    /**
     * The name of the associated bucket for the Region.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The Amazon Web Services account ID that owns the Amazon S3 bucket that's associated with this Multi-Region Access Point.
     */
    public val bucketAccountId: kotlin.String? = builder.bucketAccountId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.Region = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Region(")
        append("bucket=$bucket,")
        append("bucketAccountId=$bucketAccountId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (bucketAccountId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Region

        if (bucket != other.bucket) return false
        if (bucketAccountId != other.bucketAccountId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.Region = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the associated bucket for the Region.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the Amazon S3 bucket that's associated with this Multi-Region Access Point.
         */
        public var bucketAccountId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.Region) : this() {
            this.bucket = x.bucket
            this.bucketAccountId = x.bucketAccountId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.Region = Region(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
