// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A collection of statuses for a Multi-Region Access Point in the various Regions it supports.
 */
public class MultiRegionAccessPointReport private constructor(builder: Builder) {
    /**
     * The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see [Rules for naming Amazon S3 Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming).
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * When the Multi-Region Access Point create request was received.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the Multi-Region Access Point.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
     *
     * This data type is not supported for Amazon S3 on Outposts.
     */
    public val publicAccessBlock: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = builder.publicAccessBlock
    /**
     * A collection of the Regions and buckets associated with the Multi-Region Access Point.
     */
    public val regions: List<RegionReport>? = builder.regions
    /**
     * The current status of the Multi-Region Access Point.
     *
     * `CREATING` and `DELETING` are temporary states that exist while the request is propagating and being completed. If a Multi-Region Access Point has a status of `PARTIALLY_CREATED`, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of `PARTIALLY_DELETED`, you can retry a delete request to finish the deletion of the Multi-Region Access Point.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointReport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MultiRegionAccessPointReport(")
        append("alias=$alias,")
        append("createdAt=$createdAt,")
        append("name=$name,")
        append("publicAccessBlock=$publicAccessBlock,")
        append("regions=$regions,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publicAccessBlock?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MultiRegionAccessPointReport

        if (alias != other.alias) return false
        if (createdAt != other.createdAt) return false
        if (name != other.name) return false
        if (publicAccessBlock != other.publicAccessBlock) return false
        if (regions != other.regions) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointReport = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see [Rules for naming Amazon S3 Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming).
         */
        public var alias: kotlin.String? = null
        /**
         * When the Multi-Region Access Point create request was received.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Multi-Region Access Point.
         */
        public var name: kotlin.String? = null
        /**
         * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
         *
         * This data type is not supported for Amazon S3 on Outposts.
         */
        public var publicAccessBlock: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = null
        /**
         * A collection of the Regions and buckets associated with the Multi-Region Access Point.
         */
        public var regions: List<RegionReport>? = null
        /**
         * The current status of the Multi-Region Access Point.
         *
         * `CREATING` and `DELETING` are temporary states that exist while the request is propagating and being completed. If a Multi-Region Access Point has a status of `PARTIALLY_CREATED`, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of `PARTIALLY_DELETED`, you can retry a delete request to finish the deletion of the Multi-Region Access Point.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointReport) : this() {
            this.alias = x.alias
            this.createdAt = x.createdAt
            this.name = x.name
            this.publicAccessBlock = x.publicAccessBlock
            this.regions = x.regions
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointReport = MultiRegionAccessPointReport(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration] inside the given [block]
         */
        public fun publicAccessBlock(block: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.publicAccessBlock = aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
