// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container for the filter of the lifecycle rule.
 */
public class LifecycleRuleFilter private constructor(builder: Builder) {
    /**
     * The container for the `AND` condition for the lifecycle rule.
     */
    public val and: aws.sdk.kotlin.services.s3control.model.LifecycleRuleAndOperator? = builder.and
    /**
     * Minimum object size to which the rule applies.
     */
    public val objectSizeGreaterThan: kotlin.Long? = builder.objectSizeGreaterThan
    /**
     * Maximum object size to which the rule applies.
     */
    public val objectSizeLessThan: kotlin.Long? = builder.objectSizeLessThan
    /**
     * Prefix identifying one or more objects to which the rule applies.
     *
     * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * A container for a key-value name pair.
     */
    public val tag: aws.sdk.kotlin.services.s3control.model.S3Tag? = builder.tag

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleRuleFilter(")
        append("and=$and,")
        append("objectSizeGreaterThan=$objectSizeGreaterThan,")
        append("objectSizeLessThan=$objectSizeLessThan,")
        append("prefix=$prefix,")
        append("tag=$tag")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = and?.hashCode() ?: 0
        result = 31 * result + (objectSizeGreaterThan?.hashCode() ?: 0)
        result = 31 * result + (objectSizeLessThan?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (tag?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleRuleFilter

        if (and != other.and) return false
        if (objectSizeGreaterThan != other.objectSizeGreaterThan) return false
        if (objectSizeLessThan != other.objectSizeLessThan) return false
        if (prefix != other.prefix) return false
        if (tag != other.tag) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The container for the `AND` condition for the lifecycle rule.
         */
        public var and: aws.sdk.kotlin.services.s3control.model.LifecycleRuleAndOperator? = null
        /**
         * Minimum object size to which the rule applies.
         */
        public var objectSizeGreaterThan: kotlin.Long? = null
        /**
         * Maximum object size to which the rule applies.
         */
        public var objectSizeLessThan: kotlin.Long? = null
        /**
         * Prefix identifying one or more objects to which the rule applies.
         *
         * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
         */
        public var prefix: kotlin.String? = null
        /**
         * A container for a key-value name pair.
         */
        public var tag: aws.sdk.kotlin.services.s3control.model.S3Tag? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter) : this() {
            this.and = x.and
            this.objectSizeGreaterThan = x.objectSizeGreaterThan
            this.objectSizeLessThan = x.objectSizeLessThan
            this.prefix = x.prefix
            this.tag = x.tag
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter = LifecycleRuleFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.LifecycleRuleAndOperator] inside the given [block]
         */
        public fun and(block: aws.sdk.kotlin.services.s3control.model.LifecycleRuleAndOperator.Builder.() -> kotlin.Unit) {
            this.and = aws.sdk.kotlin.services.s3control.model.LifecycleRuleAndOperator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3Tag] inside the given [block]
         */
        public fun tag(block: aws.sdk.kotlin.services.s3control.model.S3Tag.Builder.() -> kotlin.Unit) {
            this.tag = aws.sdk.kotlin.services.s3control.model.S3Tag.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
