// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the information required to locate a manifest object. Manifests can't be imported from directory buckets. For more information, see [Directory buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html).
 */
public class JobManifestLocation private constructor(builder: Builder) {
    /**
     * The ETag for the specified manifest object.
     */
    public val eTag: kotlin.String = requireNotNull(builder.eTag) { "A non-null value must be provided for eTag" }
    /**
     * The Amazon Resource Name (ARN) for a manifest object.
     *
     * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
     */
    public val objectArn: kotlin.String = requireNotNull(builder.objectArn) { "A non-null value must be provided for objectArn" }
    /**
     * The optional version ID to identify a specific version of the manifest object.
     */
    public val objectVersionId: kotlin.String? = builder.objectVersionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobManifestLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobManifestLocation(")
        append("eTag=$eTag,")
        append("objectArn=$objectArn,")
        append("objectVersionId=$objectVersionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eTag.hashCode()
        result = 31 * result + (objectArn.hashCode())
        result = 31 * result + (objectVersionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobManifestLocation

        if (eTag != other.eTag) return false
        if (objectArn != other.objectArn) return false
        if (objectVersionId != other.objectVersionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobManifestLocation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ETag for the specified manifest object.
         */
        public var eTag: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a manifest object.
         *
         * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
         */
        public var objectArn: kotlin.String? = null
        /**
         * The optional version ID to identify a specific version of the manifest object.
         */
        public var objectVersionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobManifestLocation) : this() {
            this.eTag = x.eTag
            this.objectArn = x.objectArn
            this.objectVersionId = x.objectVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobManifestLocation = JobManifestLocation(this)

        internal fun correctErrors(): Builder {
            if (eTag == null) eTag = ""
            if (objectArn == null) objectArn = ""
            return this
        }
    }
}
