// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateBucketRequest private constructor(builder: Builder) {
    /**
     * The canned ACL to apply to the bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val acl: aws.sdk.kotlin.services.s3control.model.BucketCannedAcl? = builder.acl
    /**
     * The name of the bucket.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The configuration information for the bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val createBucketConfiguration: aws.sdk.kotlin.services.s3control.model.CreateBucketConfiguration? = builder.createBucketConfiguration
    /**
     * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val grantFullControl: kotlin.String? = builder.grantFullControl
    /**
     * Allows grantee to list the objects in the bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val grantRead: kotlin.String? = builder.grantRead
    /**
     * Allows grantee to read the bucket ACL.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val grantReadAcp: kotlin.String? = builder.grantReadAcp
    /**
     * Allows grantee to create, overwrite, and delete any object in the bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val grantWrite: kotlin.String? = builder.grantWrite
    /**
     * Allows grantee to write the ACL for the applicable bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val grantWriteAcp: kotlin.String? = builder.grantWriteAcp
    /**
     * Specifies whether you want S3 Object Lock to be enabled for the new bucket.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val objectLockEnabledForBucket: kotlin.Boolean? = builder.objectLockEnabledForBucket
    /**
     * The ID of the Outposts where the bucket is being created.
     *
     * This ID is required by Amazon S3 on Outposts buckets.
     */
    public val outpostId: kotlin.String? = builder.outpostId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateBucketRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBucketRequest(")
        append("acl=$acl,")
        append("bucket=$bucket,")
        append("createBucketConfiguration=$createBucketConfiguration,")
        append("grantFullControl=$grantFullControl,")
        append("grantRead=$grantRead,")
        append("grantReadAcp=$grantReadAcp,")
        append("grantWrite=$grantWrite,")
        append("grantWriteAcp=$grantWriteAcp,")
        append("objectLockEnabledForBucket=$objectLockEnabledForBucket,")
        append("outpostId=$outpostId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acl?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (createBucketConfiguration?.hashCode() ?: 0)
        result = 31 * result + (grantFullControl?.hashCode() ?: 0)
        result = 31 * result + (grantRead?.hashCode() ?: 0)
        result = 31 * result + (grantReadAcp?.hashCode() ?: 0)
        result = 31 * result + (grantWrite?.hashCode() ?: 0)
        result = 31 * result + (grantWriteAcp?.hashCode() ?: 0)
        result = 31 * result + (objectLockEnabledForBucket?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBucketRequest

        if (acl != other.acl) return false
        if (bucket != other.bucket) return false
        if (createBucketConfiguration != other.createBucketConfiguration) return false
        if (grantFullControl != other.grantFullControl) return false
        if (grantRead != other.grantRead) return false
        if (grantReadAcp != other.grantReadAcp) return false
        if (grantWrite != other.grantWrite) return false
        if (grantWriteAcp != other.grantWriteAcp) return false
        if (objectLockEnabledForBucket != other.objectLockEnabledForBucket) return false
        if (outpostId != other.outpostId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateBucketRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The canned ACL to apply to the bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var acl: aws.sdk.kotlin.services.s3control.model.BucketCannedAcl? = null
        /**
         * The name of the bucket.
         */
        public var bucket: kotlin.String? = null
        /**
         * The configuration information for the bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var createBucketConfiguration: aws.sdk.kotlin.services.s3control.model.CreateBucketConfiguration? = null
        /**
         * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var grantFullControl: kotlin.String? = null
        /**
         * Allows grantee to list the objects in the bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var grantRead: kotlin.String? = null
        /**
         * Allows grantee to read the bucket ACL.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var grantReadAcp: kotlin.String? = null
        /**
         * Allows grantee to create, overwrite, and delete any object in the bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var grantWrite: kotlin.String? = null
        /**
         * Allows grantee to write the ACL for the applicable bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var grantWriteAcp: kotlin.String? = null
        /**
         * Specifies whether you want S3 Object Lock to be enabled for the new bucket.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var objectLockEnabledForBucket: kotlin.Boolean? = null
        /**
         * The ID of the Outposts where the bucket is being created.
         *
         * This ID is required by Amazon S3 on Outposts buckets.
         */
        public var outpostId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateBucketRequest) : this() {
            this.acl = x.acl
            this.bucket = x.bucket
            this.createBucketConfiguration = x.createBucketConfiguration
            this.grantFullControl = x.grantFullControl
            this.grantRead = x.grantRead
            this.grantReadAcp = x.grantReadAcp
            this.grantWrite = x.grantWrite
            this.grantWriteAcp = x.grantWriteAcp
            this.objectLockEnabledForBucket = x.objectLockEnabledForBucket
            this.outpostId = x.outpostId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateBucketRequest = CreateBucketRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.CreateBucketConfiguration] inside the given [block]
         */
        public fun createBucketConfiguration(block: aws.sdk.kotlin.services.s3control.model.CreateBucketConfiguration.Builder.() -> kotlin.Unit) {
            this.createBucketConfiguration = aws.sdk.kotlin.services.s3control.model.CreateBucketConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
