// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateAccessGrantsLocationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the location you are registering.
     */
    public val accessGrantsLocationArn: kotlin.String? = builder.accessGrantsLocationArn
    /**
     * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
     */
    public val accessGrantsLocationId: kotlin.String? = builder.accessGrantsLocationId
    /**
     * The date and time when you registered the location.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The S3 URI path to the location that you are registering. The location scope can be the default S3 location `s3://`, the S3 path to a bucket, or the S3 path to a bucket and prefix. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the `engineering/` prefix or object key names that start with the `marketing/campaigns/` prefix.
     */
    public val locationScope: kotlin.String? = builder.locationScope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessGrantsLocationResponse(")
        append("accessGrantsLocationArn=$accessGrantsLocationArn,")
        append("accessGrantsLocationId=$accessGrantsLocationId,")
        append("createdAt=$createdAt,")
        append("iamRoleArn=$iamRoleArn,")
        append("locationScope=$locationScope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessGrantsLocationArn?.hashCode() ?: 0
        result = 31 * result + (accessGrantsLocationId?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (locationScope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessGrantsLocationResponse

        if (accessGrantsLocationArn != other.accessGrantsLocationArn) return false
        if (accessGrantsLocationId != other.accessGrantsLocationId) return false
        if (createdAt != other.createdAt) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (locationScope != other.locationScope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the location you are registering.
         */
        public var accessGrantsLocationArn: kotlin.String? = null
        /**
         * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
         */
        public var accessGrantsLocationId: kotlin.String? = null
        /**
         * The date and time when you registered the location.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The S3 URI path to the location that you are registering. The location scope can be the default S3 location `s3://`, the S3 path to a bucket, or the S3 path to a bucket and prefix. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the `engineering/` prefix or object key names that start with the `marketing/campaigns/` prefix.
         */
        public var locationScope: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationResponse) : this() {
            this.accessGrantsLocationArn = x.accessGrantsLocationArn
            this.accessGrantsLocationId = x.accessGrantsLocationId
            this.createdAt = x.createdAt
            this.iamRoleArn = x.iamRoleArn
            this.locationScope = x.locationScope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationResponse = CreateAccessGrantsLocationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
