// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.endpoints.internal

import aws.sdk.kotlin.services.s3control.S3ControlClient
import aws.sdk.kotlin.services.s3control.endpoints.S3ControlEndpointParameters
import aws.sdk.kotlin.services.s3control.model.AssociateAccessGrantsIdentityCenterRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsInstanceRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.CreateBucketRequest
import aws.sdk.kotlin.services.s3control.model.CreateJobRequest
import aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.CreateStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsInstanceRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsInstanceResourcePolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeletePublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.DescribeJobRequest
import aws.sdk.kotlin.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
import aws.sdk.kotlin.services.s3control.model.DissociateAccessGrantsIdentityCenterRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceForPrefixRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceResourcePolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketVersioningRequest
import aws.sdk.kotlin.services.s3control.model.GetDataAccessRequest
import aws.sdk.kotlin.services.s3control.model.GetJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
import aws.sdk.kotlin.services.s3control.model.GetPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstancesRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsLocationsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListJobsRequest
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupsRequest
import aws.sdk.kotlin.services.s3control.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessGrantsInstanceResourcePolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketVersioningRequest
import aws.sdk.kotlin.services.s3control.model.PutJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
import aws.sdk.kotlin.services.s3control.model.TagResourceRequest
import aws.sdk.kotlin.services.s3control.model.UntagResourceRequest
import aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.UpdateJobPriorityRequest
import aws.sdk.kotlin.services.s3control.model.UpdateJobStatusRequest
import aws.sdk.kotlin.services.s3control.model.UpdateStorageLensGroupRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: S3ControlClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: S3ControlClient.Config, request: ResolveEndpointRequest): S3ControlEndpointParameters {
    return S3ControlEndpointParameters {
        region = config.region
        bindAwsBuiltins(config, request)
        endpoint = config.endpointUrl?.toString()
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (S3ControlEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "AssociateAccessGrantsIdentityCenter" to ::bindAssociateAccessGrantsIdentityCenterEndpointContext,
    "CreateAccessGrant" to ::bindCreateAccessGrantEndpointContext,
    "CreateAccessGrantsInstance" to ::bindCreateAccessGrantsInstanceEndpointContext,
    "CreateAccessGrantsLocation" to ::bindCreateAccessGrantsLocationEndpointContext,
    "CreateAccessPoint" to ::bindCreateAccessPointEndpointContext,
    "CreateAccessPointForObjectLambda" to ::bindCreateAccessPointForObjectLambdaEndpointContext,
    "CreateBucket" to ::bindCreateBucketEndpointContext,
    "CreateJob" to ::bindCreateJobEndpointContext,
    "CreateMultiRegionAccessPoint" to ::bindCreateMultiRegionAccessPointEndpointContext,
    "CreateStorageLensGroup" to ::bindCreateStorageLensGroupEndpointContext,
    "DeleteAccessGrant" to ::bindDeleteAccessGrantEndpointContext,
    "DeleteAccessGrantsInstance" to ::bindDeleteAccessGrantsInstanceEndpointContext,
    "DeleteAccessGrantsInstanceResourcePolicy" to ::bindDeleteAccessGrantsInstanceResourcePolicyEndpointContext,
    "DeleteAccessGrantsLocation" to ::bindDeleteAccessGrantsLocationEndpointContext,
    "DeleteAccessPoint" to ::bindDeleteAccessPointEndpointContext,
    "DeleteAccessPointForObjectLambda" to ::bindDeleteAccessPointForObjectLambdaEndpointContext,
    "DeleteAccessPointPolicy" to ::bindDeleteAccessPointPolicyEndpointContext,
    "DeleteAccessPointPolicyForObjectLambda" to ::bindDeleteAccessPointPolicyForObjectLambdaEndpointContext,
    "DeleteBucket" to ::bindDeleteBucketEndpointContext,
    "DeleteBucketLifecycleConfiguration" to ::bindDeleteBucketLifecycleConfigurationEndpointContext,
    "DeleteBucketPolicy" to ::bindDeleteBucketPolicyEndpointContext,
    "DeleteBucketReplication" to ::bindDeleteBucketReplicationEndpointContext,
    "DeleteBucketTagging" to ::bindDeleteBucketTaggingEndpointContext,
    "DeleteJobTagging" to ::bindDeleteJobTaggingEndpointContext,
    "DeleteMultiRegionAccessPoint" to ::bindDeleteMultiRegionAccessPointEndpointContext,
    "DeletePublicAccessBlock" to ::bindDeletePublicAccessBlockEndpointContext,
    "DeleteStorageLensConfiguration" to ::bindDeleteStorageLensConfigurationEndpointContext,
    "DeleteStorageLensConfigurationTagging" to ::bindDeleteStorageLensConfigurationTaggingEndpointContext,
    "DeleteStorageLensGroup" to ::bindDeleteStorageLensGroupEndpointContext,
    "DescribeJob" to ::bindDescribeJobEndpointContext,
    "DescribeMultiRegionAccessPointOperation" to ::bindDescribeMultiRegionAccessPointOperationEndpointContext,
    "DissociateAccessGrantsIdentityCenter" to ::bindDissociateAccessGrantsIdentityCenterEndpointContext,
    "GetAccessGrant" to ::bindGetAccessGrantEndpointContext,
    "GetAccessGrantsInstance" to ::bindGetAccessGrantsInstanceEndpointContext,
    "GetAccessGrantsInstanceForPrefix" to ::bindGetAccessGrantsInstanceForPrefixEndpointContext,
    "GetAccessGrantsInstanceResourcePolicy" to ::bindGetAccessGrantsInstanceResourcePolicyEndpointContext,
    "GetAccessGrantsLocation" to ::bindGetAccessGrantsLocationEndpointContext,
    "GetAccessPoint" to ::bindGetAccessPointEndpointContext,
    "GetAccessPointConfigurationForObjectLambda" to ::bindGetAccessPointConfigurationForObjectLambdaEndpointContext,
    "GetAccessPointForObjectLambda" to ::bindGetAccessPointForObjectLambdaEndpointContext,
    "GetAccessPointPolicy" to ::bindGetAccessPointPolicyEndpointContext,
    "GetAccessPointPolicyForObjectLambda" to ::bindGetAccessPointPolicyForObjectLambdaEndpointContext,
    "GetAccessPointPolicyStatus" to ::bindGetAccessPointPolicyStatusEndpointContext,
    "GetAccessPointPolicyStatusForObjectLambda" to ::bindGetAccessPointPolicyStatusForObjectLambdaEndpointContext,
    "GetBucket" to ::bindGetBucketEndpointContext,
    "GetBucketLifecycleConfiguration" to ::bindGetBucketLifecycleConfigurationEndpointContext,
    "GetBucketPolicy" to ::bindGetBucketPolicyEndpointContext,
    "GetBucketReplication" to ::bindGetBucketReplicationEndpointContext,
    "GetBucketTagging" to ::bindGetBucketTaggingEndpointContext,
    "GetBucketVersioning" to ::bindGetBucketVersioningEndpointContext,
    "GetDataAccess" to ::bindGetDataAccessEndpointContext,
    "GetJobTagging" to ::bindGetJobTaggingEndpointContext,
    "GetMultiRegionAccessPoint" to ::bindGetMultiRegionAccessPointEndpointContext,
    "GetMultiRegionAccessPointPolicy" to ::bindGetMultiRegionAccessPointPolicyEndpointContext,
    "GetMultiRegionAccessPointPolicyStatus" to ::bindGetMultiRegionAccessPointPolicyStatusEndpointContext,
    "GetMultiRegionAccessPointRoutes" to ::bindGetMultiRegionAccessPointRoutesEndpointContext,
    "GetPublicAccessBlock" to ::bindGetPublicAccessBlockEndpointContext,
    "GetStorageLensConfiguration" to ::bindGetStorageLensConfigurationEndpointContext,
    "GetStorageLensConfigurationTagging" to ::bindGetStorageLensConfigurationTaggingEndpointContext,
    "GetStorageLensGroup" to ::bindGetStorageLensGroupEndpointContext,
    "ListAccessGrants" to ::bindListAccessGrantsEndpointContext,
    "ListAccessGrantsInstances" to ::bindListAccessGrantsInstancesEndpointContext,
    "ListAccessGrantsLocations" to ::bindListAccessGrantsLocationsEndpointContext,
    "ListAccessPoints" to ::bindListAccessPointsEndpointContext,
    "ListAccessPointsForObjectLambda" to ::bindListAccessPointsForObjectLambdaEndpointContext,
    "ListJobs" to ::bindListJobsEndpointContext,
    "ListMultiRegionAccessPoints" to ::bindListMultiRegionAccessPointsEndpointContext,
    "ListRegionalBuckets" to ::bindListRegionalBucketsEndpointContext,
    "ListStorageLensConfigurations" to ::bindListStorageLensConfigurationsEndpointContext,
    "ListStorageLensGroups" to ::bindListStorageLensGroupsEndpointContext,
    "ListTagsForResource" to ::bindListTagsForResourceEndpointContext,
    "PutAccessGrantsInstanceResourcePolicy" to ::bindPutAccessGrantsInstanceResourcePolicyEndpointContext,
    "PutAccessPointConfigurationForObjectLambda" to ::bindPutAccessPointConfigurationForObjectLambdaEndpointContext,
    "PutAccessPointPolicy" to ::bindPutAccessPointPolicyEndpointContext,
    "PutAccessPointPolicyForObjectLambda" to ::bindPutAccessPointPolicyForObjectLambdaEndpointContext,
    "PutBucketLifecycleConfiguration" to ::bindPutBucketLifecycleConfigurationEndpointContext,
    "PutBucketPolicy" to ::bindPutBucketPolicyEndpointContext,
    "PutBucketReplication" to ::bindPutBucketReplicationEndpointContext,
    "PutBucketTagging" to ::bindPutBucketTaggingEndpointContext,
    "PutBucketVersioning" to ::bindPutBucketVersioningEndpointContext,
    "PutJobTagging" to ::bindPutJobTaggingEndpointContext,
    "PutMultiRegionAccessPointPolicy" to ::bindPutMultiRegionAccessPointPolicyEndpointContext,
    "PutPublicAccessBlock" to ::bindPutPublicAccessBlockEndpointContext,
    "PutStorageLensConfiguration" to ::bindPutStorageLensConfigurationEndpointContext,
    "PutStorageLensConfigurationTagging" to ::bindPutStorageLensConfigurationTaggingEndpointContext,
    "SubmitMultiRegionAccessPointRoutes" to ::bindSubmitMultiRegionAccessPointRoutesEndpointContext,
    "TagResource" to ::bindTagResourceEndpointContext,
    "UntagResource" to ::bindUntagResourceEndpointContext,
    "UpdateAccessGrantsLocation" to ::bindUpdateAccessGrantsLocationEndpointContext,
    "UpdateJobPriority" to ::bindUpdateJobPriorityEndpointContext,
    "UpdateJobStatus" to ::bindUpdateJobStatusEndpointContext,
    "UpdateStorageLensGroup" to ::bindUpdateStorageLensGroupEndpointContext,
)

private fun S3ControlEndpointParameters.Builder.bindAwsBuiltins(config: S3ControlClient.Config, request: ResolveEndpointRequest) {
    useFips = config.useFips
    useDualStack = config.useDualStack
    useArnRegion = config.useArnRegion
}

private fun bindAssociateAccessGrantsIdentityCenterEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as AssociateAccessGrantsIdentityCenterRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateAccessGrantEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessGrantRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateAccessGrantsInstanceEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessGrantsInstanceRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateAccessGrantsLocationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessGrantsLocationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateAccessPointEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindCreateAccessPointForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessPointForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateBucketEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateBucketRequest
    builder.outpostId = input.outpostId
    builder.bucket = input.bucket
}

private fun bindCreateJobEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateJobRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateMultiRegionAccessPointEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateMultiRegionAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateStorageLensGroupEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateStorageLensGroupRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessGrantEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessGrantRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessGrantsInstanceEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessGrantsInstanceRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessGrantsInstanceResourcePolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessGrantsInstanceResourcePolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessGrantsLocationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessGrantsLocationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessPointEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindDeleteAccessPointForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessPointPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindDeleteAccessPointPolicyForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointPolicyForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteBucketEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketLifecycleConfigurationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketLifecycleConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketReplicationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketReplicationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteJobTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteJobTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteMultiRegionAccessPointEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteMultiRegionAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeletePublicAccessBlockEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeletePublicAccessBlockRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteStorageLensConfigurationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStorageLensConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteStorageLensConfigurationTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStorageLensConfigurationTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteStorageLensGroupEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStorageLensGroupRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDescribeJobEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeJobRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDescribeMultiRegionAccessPointOperationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeMultiRegionAccessPointOperationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDissociateAccessGrantsIdentityCenterEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DissociateAccessGrantsIdentityCenterRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessGrantEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessGrantRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessGrantsInstanceEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessGrantsInstanceRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessGrantsInstanceForPrefixEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessGrantsInstanceForPrefixRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessGrantsInstanceResourcePolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessGrantsInstanceResourcePolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessGrantsLocationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessGrantsLocationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindGetAccessPointConfigurationForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointConfigurationForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindGetAccessPointPolicyForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointPolicyStatusEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyStatusRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindGetAccessPointPolicyStatusForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyStatusForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetBucketEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketLifecycleConfigurationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketLifecycleConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketReplicationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketReplicationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketVersioningEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketVersioningRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetDataAccessEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetDataAccessRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetJobTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetJobTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointPolicyStatusEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointPolicyStatusRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointRoutesEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointRoutesRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetPublicAccessBlockEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetPublicAccessBlockRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetStorageLensConfigurationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetStorageLensConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetStorageLensConfigurationTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetStorageLensConfigurationTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetStorageLensGroupEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetStorageLensGroupRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListAccessGrantsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessGrantsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListAccessGrantsInstancesEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessGrantsInstancesRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListAccessGrantsLocationsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessGrantsLocationsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListAccessPointsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessPointsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindListAccessPointsForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessPointsForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListJobsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListJobsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListMultiRegionAccessPointsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListMultiRegionAccessPointsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListRegionalBucketsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListRegionalBucketsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.outpostId = input.outpostId
}

private fun bindListStorageLensConfigurationsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListStorageLensConfigurationsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListStorageLensGroupsEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListStorageLensGroupsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListTagsForResourceEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListTagsForResourceRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutAccessGrantsInstanceResourcePolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessGrantsInstanceResourcePolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutAccessPointConfigurationForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessPointConfigurationForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutAccessPointPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindPutAccessPointPolicyForObjectLambdaEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessPointPolicyForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutBucketLifecycleConfigurationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketLifecycleConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketReplicationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketReplicationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketVersioningEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketVersioningRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutJobTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutJobTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutMultiRegionAccessPointPolicyEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutMultiRegionAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutPublicAccessBlockEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutPublicAccessBlockRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutStorageLensConfigurationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutStorageLensConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutStorageLensConfigurationTaggingEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutStorageLensConfigurationTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindSubmitMultiRegionAccessPointRoutesEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as SubmitMultiRegionAccessPointRoutesRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindTagResourceEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as TagResourceRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUntagResourceEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UntagResourceRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUpdateAccessGrantsLocationEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateAccessGrantsLocationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUpdateJobPriorityEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateJobPriorityRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUpdateJobStatusEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateJobStatusRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUpdateStorageLensGroupEndpointContext(builder: S3ControlEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateStorageLensGroupRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}
