// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.S3CannedAccessControlList
import aws.sdk.kotlin.services.s3control.model.S3ChecksumAlgorithm
import aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation
import aws.sdk.kotlin.services.s3control.model.S3MetadataDirective
import aws.sdk.kotlin.services.s3control.model.S3ObjectLockLegalHoldStatus
import aws.sdk.kotlin.services.s3control.model.S3ObjectLockMode
import aws.sdk.kotlin.services.s3control.model.S3StorageClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeS3CopyObjectOperationDocument(reader: XmlTagReader): S3CopyObjectOperation {
    val builder = S3CopyObjectOperation.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // TargetResource com.amazonaws.s3control#S3CopyObjectOperation$TargetResource
            "TargetResource" -> builder.targetResource = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3RegionalOrS3ExpressBucketArnString`)" }
            // CannedAccessControlList com.amazonaws.s3control#S3CopyObjectOperation$CannedAccessControlList
            "CannedAccessControlList" -> builder.cannedAccessControlList = curr.tryData()
                .parse { S3CannedAccessControlList.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3CannedAccessControlList`)" }
            // AccessControlGrants com.amazonaws.s3control#S3CopyObjectOperation$AccessControlGrants
            "AccessControlGrants" -> builder.accessControlGrants = deserializeS3GrantListShape(curr)
            // MetadataDirective com.amazonaws.s3control#S3CopyObjectOperation$MetadataDirective
            "MetadataDirective" -> builder.metadataDirective = curr.tryData()
                .parse { S3MetadataDirective.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3MetadataDirective`)" }
            // ModifiedSinceConstraint com.amazonaws.s3control#S3CopyObjectOperation$ModifiedSinceConstraint
            "ModifiedSinceConstraint" -> builder.modifiedSinceConstraint = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#TimeStamp`)" }
            // NewObjectMetadata com.amazonaws.s3control#S3CopyObjectOperation$NewObjectMetadata
            "NewObjectMetadata" -> builder.newObjectMetadata = deserializeS3ObjectMetadataDocument(curr)
            // NewObjectTagging com.amazonaws.s3control#S3CopyObjectOperation$NewObjectTagging
            "NewObjectTagging" -> builder.newObjectTagging = deserializeS3TagSetShape(curr)
            // RedirectLocation com.amazonaws.s3control#S3CopyObjectOperation$RedirectLocation
            "RedirectLocation" -> builder.redirectLocation = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength2048String`)" }
            // RequesterPays com.amazonaws.s3control#S3CopyObjectOperation$RequesterPays
            "RequesterPays" -> builder.requesterPays = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#Boolean`)" }
            // StorageClass com.amazonaws.s3control#S3CopyObjectOperation$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { S3StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3StorageClass`)" }
            // UnModifiedSinceConstraint com.amazonaws.s3control#S3CopyObjectOperation$UnModifiedSinceConstraint
            "UnModifiedSinceConstraint" -> builder.unModifiedSinceConstraint = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#TimeStamp`)" }
            // SSEAwsKmsKeyId com.amazonaws.s3control#S3CopyObjectOperation$SSEAwsKmsKeyId
            "SSEAwsKmsKeyId" -> builder.sseAwsKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#KmsKeyArnString`)" }
            // TargetKeyPrefix com.amazonaws.s3control#S3CopyObjectOperation$TargetKeyPrefix
            "TargetKeyPrefix" -> builder.targetKeyPrefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#NonEmptyMaxLength1024String`)" }
            // ObjectLockLegalHoldStatus com.amazonaws.s3control#S3CopyObjectOperation$ObjectLockLegalHoldStatus
            "ObjectLockLegalHoldStatus" -> builder.objectLockLegalHoldStatus = curr.tryData()
                .parse { S3ObjectLockLegalHoldStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3ObjectLockLegalHoldStatus`)" }
            // ObjectLockMode com.amazonaws.s3control#S3CopyObjectOperation$ObjectLockMode
            "ObjectLockMode" -> builder.objectLockMode = curr.tryData()
                .parse { S3ObjectLockMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3ObjectLockMode`)" }
            // ObjectLockRetainUntilDate com.amazonaws.s3control#S3CopyObjectOperation$ObjectLockRetainUntilDate
            "ObjectLockRetainUntilDate" -> builder.objectLockRetainUntilDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#TimeStamp`)" }
            // BucketKeyEnabled com.amazonaws.s3control#S3CopyObjectOperation$BucketKeyEnabled
            "BucketKeyEnabled" -> builder.bucketKeyEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#Boolean`)" }
            // ChecksumAlgorithm com.amazonaws.s3control#S3CopyObjectOperation$ChecksumAlgorithm
            "ChecksumAlgorithm" -> builder.checksumAlgorithm = curr.tryData()
                .parse { S3ChecksumAlgorithm.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3ChecksumAlgorithm`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
