// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeJobManifestGeneratorFilterDocument(reader: XmlTagReader): JobManifestGeneratorFilter {
    val builder = JobManifestGeneratorFilter.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // EligibleForReplication com.amazonaws.s3control#JobManifestGeneratorFilter$EligibleForReplication
            "EligibleForReplication" -> builder.eligibleForReplication = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#Boolean`)" }
            // CreatedAfter com.amazonaws.s3control#JobManifestGeneratorFilter$CreatedAfter
            "CreatedAfter" -> builder.createdAfter = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#ObjectCreationTime`)" }
            // CreatedBefore com.amazonaws.s3control#JobManifestGeneratorFilter$CreatedBefore
            "CreatedBefore" -> builder.createdBefore = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#ObjectCreationTime`)" }
            // ObjectReplicationStatuses com.amazonaws.s3control#JobManifestGeneratorFilter$ObjectReplicationStatuses
            "ObjectReplicationStatuses" -> builder.objectReplicationStatuses = deserializeReplicationStatusFilterListShape(curr)
            // KeyNameConstraint com.amazonaws.s3control#JobManifestGeneratorFilter$KeyNameConstraint
            "KeyNameConstraint" -> builder.keyNameConstraint = deserializeKeyNameConstraintDocument(curr)
            // ObjectSizeGreaterThanBytes com.amazonaws.s3control#JobManifestGeneratorFilter$ObjectSizeGreaterThanBytes
            "ObjectSizeGreaterThanBytes" -> builder.objectSizeGreaterThanBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.s3control#ObjectSizeGreaterThanBytes`)" }
            // ObjectSizeLessThanBytes com.amazonaws.s3control#JobManifestGeneratorFilter$ObjectSizeLessThanBytes
            "ObjectSizeLessThanBytes" -> builder.objectSizeLessThanBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.s3control#ObjectSizeLessThanBytes`)" }
            // MatchAnyStorageClass com.amazonaws.s3control#JobManifestGeneratorFilter$MatchAnyStorageClass
            "MatchAnyStorageClass" -> builder.matchAnyStorageClass = deserializeStorageClassListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
