// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container element for specifying `Or` rule conditions. The rule conditions determine the subset of objects to which the `Or` rule applies. Objects can match any of the listed filter conditions, which are joined by the `Or` logical operator. Only one of each filter condition is allowed.
 */
public class StorageLensGroupOrOperator private constructor(builder: Builder) {
    /**
     * Filters objects that match any of the specified prefixes.
     */
    public val matchAnyPrefix: List<String>? = builder.matchAnyPrefix
    /**
     * Filters objects that match any of the specified suffixes.
     */
    public val matchAnySuffix: List<String>? = builder.matchAnySuffix
    /**
     * Filters objects that match any of the specified S3 object tags.
     */
    public val matchAnyTag: List<S3Tag>? = builder.matchAnyTag
    /**
     * Filters objects that match the specified object age range.
     */
    public val matchObjectAge: aws.sdk.kotlin.services.s3control.model.MatchObjectAge? = builder.matchObjectAge
    /**
     * Filters objects that match the specified object size range.
     */
    public val matchObjectSize: aws.sdk.kotlin.services.s3control.model.MatchObjectSize? = builder.matchObjectSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageLensGroupOrOperator(")
        append("matchAnyPrefix=$matchAnyPrefix,")
        append("matchAnySuffix=$matchAnySuffix,")
        append("matchAnyTag=$matchAnyTag,")
        append("matchObjectAge=$matchObjectAge,")
        append("matchObjectSize=$matchObjectSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = matchAnyPrefix?.hashCode() ?: 0
        result = 31 * result + (matchAnySuffix?.hashCode() ?: 0)
        result = 31 * result + (matchAnyTag?.hashCode() ?: 0)
        result = 31 * result + (matchObjectAge?.hashCode() ?: 0)
        result = 31 * result + (matchObjectSize?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageLensGroupOrOperator

        if (matchAnyPrefix != other.matchAnyPrefix) return false
        if (matchAnySuffix != other.matchAnySuffix) return false
        if (matchAnyTag != other.matchAnyTag) return false
        if (matchObjectAge != other.matchObjectAge) return false
        if (matchObjectSize != other.matchObjectSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Filters objects that match any of the specified prefixes.
         */
        public var matchAnyPrefix: List<String>? = null
        /**
         * Filters objects that match any of the specified suffixes.
         */
        public var matchAnySuffix: List<String>? = null
        /**
         * Filters objects that match any of the specified S3 object tags.
         */
        public var matchAnyTag: List<S3Tag>? = null
        /**
         * Filters objects that match the specified object age range.
         */
        public var matchObjectAge: aws.sdk.kotlin.services.s3control.model.MatchObjectAge? = null
        /**
         * Filters objects that match the specified object size range.
         */
        public var matchObjectSize: aws.sdk.kotlin.services.s3control.model.MatchObjectSize? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator) : this() {
            this.matchAnyPrefix = x.matchAnyPrefix
            this.matchAnySuffix = x.matchAnySuffix
            this.matchAnyTag = x.matchAnyTag
            this.matchObjectAge = x.matchObjectAge
            this.matchObjectSize = x.matchObjectSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator = StorageLensGroupOrOperator(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.MatchObjectAge] inside the given [block]
         */
        public fun matchObjectAge(block: aws.sdk.kotlin.services.s3control.model.MatchObjectAge.Builder.() -> kotlin.Unit) {
            this.matchObjectAge = aws.sdk.kotlin.services.s3control.model.MatchObjectAge.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.MatchObjectSize] inside the given [block]
         */
        public fun matchObjectSize(block: aws.sdk.kotlin.services.s3control.model.MatchObjectSize.Builder.() -> kotlin.Unit) {
            this.matchObjectSize = aws.sdk.kotlin.services.s3control.model.MatchObjectSize.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
