// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container for the bucket where the Amazon S3 Storage Lens metrics export files are located.
 */
public class S3BucketDestination private constructor(builder: Builder) {
    /**
     * The account ID of the owner of the S3 Storage Lens metrics export bucket.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: ` arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> `
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The container for the type encryption of the metrics exports in this bucket.
     */
    public val encryption: aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption? = builder.encryption
    /**
     *
     */
    public val format: aws.sdk.kotlin.services.s3control.model.Format = requireNotNull(builder.format) { "A non-null value must be provided for format" }
    /**
     * The schema version of the export file.
     */
    public val outputSchemaVersion: aws.sdk.kotlin.services.s3control.model.OutputSchemaVersion = requireNotNull(builder.outputSchemaVersion) { "A non-null value must be provided for outputSchemaVersion" }
    /**
     * The prefix of the destination bucket where the metrics export will be delivered.
     */
    public val prefix: kotlin.String? = builder.prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3BucketDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketDestination(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("encryption=$encryption,")
        append("format=$format,")
        append("outputSchemaVersion=$outputSchemaVersion,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (format.hashCode())
        result = 31 * result + (outputSchemaVersion.hashCode())
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketDestination

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (encryption != other.encryption) return false
        if (format != other.format) return false
        if (outputSchemaVersion != other.outputSchemaVersion) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3BucketDestination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID of the owner of the S3 Storage Lens metrics export bucket.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: ` arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> `
         */
        public var arn: kotlin.String? = null
        /**
         * The container for the type encryption of the metrics exports in this bucket.
         */
        public var encryption: aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption? = null
        /**
         *
         */
        public var format: aws.sdk.kotlin.services.s3control.model.Format? = null
        /**
         * The schema version of the export file.
         */
        public var outputSchemaVersion: aws.sdk.kotlin.services.s3control.model.OutputSchemaVersion? = null
        /**
         * The prefix of the destination bucket where the metrics export will be delivered.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3BucketDestination) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.encryption = x.encryption
            this.format = x.format
            this.outputSchemaVersion = x.outputSchemaVersion
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3BucketDestination = S3BucketDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            if (arn == null) arn = ""
            if (format == null) format = Format.SdkUnknown("no value provided")
            if (outputSchemaVersion == null) outputSchemaVersion = OutputSchemaVersion.SdkUnknown("no value provided")
            return this
        }
    }
}
