// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies information about the replication destination bucket and its settings for an S3 on Outposts replication configuration.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * Specify this property only in a cross-account scenario (where the source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this property is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val accessControlTranslation: aws.sdk.kotlin.services.s3control.model.AccessControlTranslation? = builder.accessControlTranslation
    /**
     * The destination bucket owner's account ID.
     */
    public val account: kotlin.String? = builder.account
    /**
     * The Amazon Resource Name (ARN) of the access point for the destination bucket where you want S3 on Outposts to store the replication results.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * A container that provides information about encryption. If `SourceSelectionCriteria` is specified, you must specify this element.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.s3control.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * A container that specifies replication metrics-related settings.
     */
    public val metrics: aws.sdk.kotlin.services.s3control.model.Metrics? = builder.metrics
    /**
     * A container that specifies S3 Replication Time Control (S3 RTC) settings, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a `Metrics` block.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val replicationTime: aws.sdk.kotlin.services.s3control.model.ReplicationTime? = builder.replicationTime
    /**
     * The storage class to use when replicating objects. All objects stored on S3 on Outposts are stored in the `OUTPOSTS` storage class. S3 on Outposts uses the `OUTPOSTS` storage class to create the object replicas.
     *
     * Values other than `OUTPOSTS` aren't supported by Amazon S3 on Outposts.
     */
    public val storageClass: aws.sdk.kotlin.services.s3control.model.ReplicationStorageClass? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("accessControlTranslation=$accessControlTranslation,")
        append("account=$account,")
        append("bucket=$bucket,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("metrics=$metrics,")
        append("replicationTime=$replicationTime,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlTranslation?.hashCode() ?: 0
        result = 31 * result + (account?.hashCode() ?: 0)
        result = 31 * result + (bucket.hashCode())
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (replicationTime?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (accessControlTranslation != other.accessControlTranslation) return false
        if (account != other.account) return false
        if (bucket != other.bucket) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (metrics != other.metrics) return false
        if (replicationTime != other.replicationTime) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify this property only in a cross-account scenario (where the source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this property is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var accessControlTranslation: aws.sdk.kotlin.services.s3control.model.AccessControlTranslation? = null
        /**
         * The destination bucket owner's account ID.
         */
        public var account: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the access point for the destination bucket where you want S3 on Outposts to store the replication results.
         */
        public var bucket: kotlin.String? = null
        /**
         * A container that provides information about encryption. If `SourceSelectionCriteria` is specified, you must specify this element.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.s3control.model.EncryptionConfiguration? = null
        /**
         * A container that specifies replication metrics-related settings.
         */
        public var metrics: aws.sdk.kotlin.services.s3control.model.Metrics? = null
        /**
         * A container that specifies S3 Replication Time Control (S3 RTC) settings, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a `Metrics` block.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var replicationTime: aws.sdk.kotlin.services.s3control.model.ReplicationTime? = null
        /**
         * The storage class to use when replicating objects. All objects stored on S3 on Outposts are stored in the `OUTPOSTS` storage class. S3 on Outposts uses the `OUTPOSTS` storage class to create the object replicas.
         *
         * Values other than `OUTPOSTS` aren't supported by Amazon S3 on Outposts.
         */
        public var storageClass: aws.sdk.kotlin.services.s3control.model.ReplicationStorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.Destination) : this() {
            this.accessControlTranslation = x.accessControlTranslation
            this.account = x.account
            this.bucket = x.bucket
            this.encryptionConfiguration = x.encryptionConfiguration
            this.metrics = x.metrics
            this.replicationTime = x.replicationTime
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.Destination = Destination(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AccessControlTranslation] inside the given [block]
         */
        public fun accessControlTranslation(block: aws.sdk.kotlin.services.s3control.model.AccessControlTranslation.Builder.() -> kotlin.Unit) {
            this.accessControlTranslation = aws.sdk.kotlin.services.s3control.model.AccessControlTranslation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.s3control.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.s3control.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.Metrics] inside the given [block]
         */
        public fun metrics(block: aws.sdk.kotlin.services.s3control.model.Metrics.Builder.() -> kotlin.Unit) {
            this.metrics = aws.sdk.kotlin.services.s3control.model.Metrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ReplicationTime] inside the given [block]
         */
        public fun replicationTime(block: aws.sdk.kotlin.services.s3control.model.ReplicationTime.Builder.() -> kotlin.Unit) {
            this.replicationTime = aws.sdk.kotlin.services.s3control.model.ReplicationTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
