// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container element for Amazon S3 Storage Lens activity metrics. Activity metrics show details about how your storage is requested, such as requests (for example, All requests, Get requests, Put requests), bytes uploaded or downloaded, and errors.
 *
 * For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*. For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html) in the *Amazon S3 User Guide*.
 */
public class ActivityMetrics private constructor(builder: Builder) {
    /**
     * A container that indicates whether activity metrics are enabled.
     */
    public val isEnabled: kotlin.Boolean = builder.isEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ActivityMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivityMetrics(")
        append("isEnabled=$isEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isEnabled.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivityMetrics

        if (isEnabled != other.isEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ActivityMetrics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A container that indicates whether activity metrics are enabled.
         */
        public var isEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ActivityMetrics) : this() {
            this.isEnabled = x.isEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ActivityMetrics = ActivityMetrics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
