// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantResponse
import aws.sdk.kotlin.services.s3control.model.Grantee
import aws.sdk.kotlin.services.s3control.model.Permission
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateAccessGrantOperationDeserializer: HttpDeserialize<CreateAccessGrantResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAccessGrantResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAccessGrantError(context, call)
        }
        val builder = CreateAccessGrantResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAccessGrantOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAccessGrantError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAccessGrantOperationBody(builder: CreateAccessGrantResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ACCESSGRANTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessGrantArn"))
    val ACCESSGRANTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessGrantId"))
    val ACCESSGRANTSLOCATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AccessGrantsLocationConfiguration"))
    val ACCESSGRANTSLOCATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessGrantsLocationId"))
    val APPLICATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ApplicationArn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreatedAt"))
    val GRANTSCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("GrantScope"))
    val GRANTEE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Grantee"))
    val PERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Permission"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateAccessGrantResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(ACCESSGRANTARN_DESCRIPTOR)
        field(ACCESSGRANTID_DESCRIPTOR)
        field(ACCESSGRANTSLOCATIONCONFIGURATION_DESCRIPTOR)
        field(ACCESSGRANTSLOCATIONID_DESCRIPTOR)
        field(APPLICATIONARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(GRANTSCOPE_DESCRIPTOR)
        field(GRANTEE_DESCRIPTOR)
        field(PERMISSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSGRANTARN_DESCRIPTOR.index -> builder.accessGrantArn = deserializeString()
                ACCESSGRANTID_DESCRIPTOR.index -> builder.accessGrantId = deserializeString()
                ACCESSGRANTSLOCATIONCONFIGURATION_DESCRIPTOR.index -> builder.accessGrantsLocationConfiguration = deserializeAccessGrantsLocationConfigurationDocument(deserializer)
                ACCESSGRANTSLOCATIONID_DESCRIPTOR.index -> builder.accessGrantsLocationId = deserializeString()
                APPLICATIONARN_DESCRIPTOR.index -> builder.applicationArn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                GRANTSCOPE_DESCRIPTOR.index -> builder.grantScope = deserializeString()
                GRANTEE_DESCRIPTOR.index -> builder.grantee = deserializeGranteeDocument(deserializer)
                PERMISSION_DESCRIPTOR.index -> builder.permission = deserializeString().let { Permission.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
