// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.paginators

import aws.sdk.kotlin.services.s3control.S3ControlClient
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstancesRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstancesResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsLocationsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsLocationsResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.ListJobsRequest
import aws.sdk.kotlin.services.s3control.model.ListJobsResponse
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsRequest
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsResponse
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsResponse
import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupsResponse
import aws.sdk.kotlin.services.s3control.model.ObjectLambdaAccessPoint
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccessGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessGrantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessGrantsResponse]
 */
public fun S3ControlClient.listAccessGrantsPaginated(initialRequest: ListAccessGrantsRequest): Flow<ListAccessGrantsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessGrantsPaginated.listAccessGrants(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessGrantsResponse]
 */
public fun S3ControlClient.listAccessGrantsPaginated(block: ListAccessGrantsRequest.Builder.() -> Unit): Flow<ListAccessGrantsResponse> =
    listAccessGrantsPaginated(ListAccessGrantsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccessGrantsInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessGrantsInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessGrantsInstancesResponse]
 */
public fun S3ControlClient.listAccessGrantsInstancesPaginated(initialRequest: ListAccessGrantsInstancesRequest): Flow<ListAccessGrantsInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessGrantsInstancesPaginated.listAccessGrantsInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessGrantsInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessGrantsInstancesResponse]
 */
public fun S3ControlClient.listAccessGrantsInstancesPaginated(block: ListAccessGrantsInstancesRequest.Builder.() -> Unit): Flow<ListAccessGrantsInstancesResponse> =
    listAccessGrantsInstancesPaginated(ListAccessGrantsInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccessGrantsLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessGrantsLocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessGrantsLocationsResponse]
 */
public fun S3ControlClient.listAccessGrantsLocationsPaginated(initialRequest: ListAccessGrantsLocationsRequest): Flow<ListAccessGrantsLocationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessGrantsLocationsPaginated.listAccessGrantsLocations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessGrantsLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessGrantsLocationsResponse]
 */
public fun S3ControlClient.listAccessGrantsLocationsPaginated(block: ListAccessGrantsLocationsRequest.Builder.() -> Unit): Flow<ListAccessGrantsLocationsResponse> =
    listAccessGrantsLocationsPaginated(ListAccessGrantsLocationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsResponse]
 */
public fun S3ControlClient.listAccessPointsPaginated(initialRequest: ListAccessPointsRequest): Flow<ListAccessPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPointsPaginated.listAccessPoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsResponse]
 */
public fun S3ControlClient.listAccessPointsPaginated(block: ListAccessPointsRequest.Builder.() -> Unit): Flow<ListAccessPointsResponse> =
    listAccessPointsPaginated(ListAccessPointsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccessPointsForObjectLambdaResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPointsForObjectLambdaRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsForObjectLambdaResponse]
 */
public fun S3ControlClient.listAccessPointsForObjectLambdaPaginated(initialRequest: ListAccessPointsForObjectLambdaRequest): Flow<ListAccessPointsForObjectLambdaResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPointsForObjectLambdaPaginated.listAccessPointsForObjectLambda(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPointsForObjectLambdaResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsForObjectLambdaResponse]
 */
public fun S3ControlClient.listAccessPointsForObjectLambdaPaginated(block: ListAccessPointsForObjectLambdaRequest.Builder.() -> Unit): Flow<ListAccessPointsForObjectLambdaResponse> =
    listAccessPointsForObjectLambdaPaginated(ListAccessPointsForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessPointsForObjectLambdaPaginated]
 * to access the nested member [ObjectLambdaAccessPoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ObjectLambdaAccessPoint]
 */
@JvmName("listAccessPointsForObjectLambdaResponseObjectLambdaAccessPoint")
public fun Flow<ListAccessPointsForObjectLambdaResponse>.objectLambdaAccessPointList(): Flow<ObjectLambdaAccessPoint> =
    transform() { response ->
        response.objectLambdaAccessPointList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun S3ControlClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun S3ControlClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMultiRegionAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMultiRegionAccessPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiRegionAccessPointsResponse]
 */
public fun S3ControlClient.listMultiRegionAccessPointsPaginated(initialRequest: ListMultiRegionAccessPointsRequest): Flow<ListMultiRegionAccessPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMultiRegionAccessPointsPaginated.listMultiRegionAccessPoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMultiRegionAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiRegionAccessPointsResponse]
 */
public fun S3ControlClient.listMultiRegionAccessPointsPaginated(block: ListMultiRegionAccessPointsRequest.Builder.() -> Unit): Flow<ListMultiRegionAccessPointsResponse> =
    listMultiRegionAccessPointsPaginated(ListMultiRegionAccessPointsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRegionalBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRegionalBucketsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegionalBucketsResponse]
 */
public fun S3ControlClient.listRegionalBucketsPaginated(initialRequest: ListRegionalBucketsRequest): Flow<ListRegionalBucketsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRegionalBucketsPaginated.listRegionalBuckets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRegionalBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegionalBucketsResponse]
 */
public fun S3ControlClient.listRegionalBucketsPaginated(block: ListRegionalBucketsRequest.Builder.() -> Unit): Flow<ListRegionalBucketsResponse> =
    listRegionalBucketsPaginated(ListRegionalBucketsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStorageLensConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStorageLensConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageLensConfigurationsResponse]
 */
public fun S3ControlClient.listStorageLensConfigurationsPaginated(initialRequest: ListStorageLensConfigurationsRequest): Flow<ListStorageLensConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStorageLensConfigurationsPaginated.listStorageLensConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStorageLensConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageLensConfigurationsResponse]
 */
public fun S3ControlClient.listStorageLensConfigurationsPaginated(block: ListStorageLensConfigurationsRequest.Builder.() -> Unit): Flow<ListStorageLensConfigurationsResponse> =
    listStorageLensConfigurationsPaginated(ListStorageLensConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStorageLensGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStorageLensGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageLensGroupsResponse]
 */
public fun S3ControlClient.listStorageLensGroupsPaginated(initialRequest: ListStorageLensGroupsRequest): Flow<ListStorageLensGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStorageLensGroupsPaginated.listStorageLensGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStorageLensGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageLensGroupsResponse]
 */
public fun S3ControlClient.listStorageLensGroupsPaginated(block: ListStorageLensGroupsRequest.Builder.() -> Unit): Flow<ListStorageLensGroupsResponse> =
    listStorageLensGroupsPaginated(ListStorageLensGroupsRequest.Builder().apply(block).build())
