// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that created the S3 resource that you're trying to add tags to or the requester's account ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the S3 resource that you're trying to add tags to. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The Amazon Web Services resource tags that you want to add to the specified S3 resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("accountId=$accountId,")
        append("resourceArn=$resourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (accountId != other.accountId) return false
        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.TagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID that created the S3 resource that you're trying to add tags to or the requester's account ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the S3 resource that you're trying to add tags to. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The Amazon Web Services resource tags that you want to add to the specified S3 resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.TagResourceRequest) : this() {
            this.accountId = x.accountId
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.TagResourceRequest = TagResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
