// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A custom grouping of objects that include filters for prefixes, suffixes, object tags, object size, or object age. You can create an S3 Storage Lens group that includes a single filter or multiple filter conditions. To specify multiple filter conditions, you use `AND` or `OR` logical operators.
 */
public class StorageLensGroup private constructor(builder: Builder) {
    /**
     * Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the `AND` or `OR` logical operator is used.
     */
    public val filter: aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter? = builder.filter
    /**
     * Contains the name of the Storage Lens group.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
     */
    public val storageLensGroupArn: kotlin.String? = builder.storageLensGroupArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.StorageLensGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageLensGroup(")
        append("filter=$filter,")
        append("name=$name,")
        append("storageLensGroupArn=$storageLensGroupArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        result = 31 * result + (storageLensGroupArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageLensGroup

        if (filter != other.filter) return false
        if (name != other.name) return false
        if (storageLensGroupArn != other.storageLensGroupArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.StorageLensGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the `AND` or `OR` logical operator is used.
         */
        public var filter: aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter? = null
        /**
         * Contains the name of the Storage Lens group.
         */
        public var name: kotlin.String? = null
        /**
         * Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
         */
        public var storageLensGroupArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.StorageLensGroup) : this() {
            this.filter = x.filter
            this.name = x.name
            this.storageLensGroupArn = x.storageLensGroupArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.StorageLensGroup = StorageLensGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
