// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
 */
public class Grantee private constructor(builder: Builder) {
    /**
     * The unique identifier of the `Grantee`. If the grantee type is `IAM`, the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`. You can obtain this UUID from your Amazon Web Services IAM Identity Center instance.
     */
    public val granteeIdentifier: kotlin.String? = builder.granteeIdentifier
    /**
     * The type of the grantee to which access has been granted. It can be one of the following values:
     * + `IAM` - An IAM user or role.
     * + `DIRECTORY_USER` - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
     * + `DIRECTORY_GROUP` - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
     */
    public val granteeType: aws.sdk.kotlin.services.s3control.model.GranteeType? = builder.granteeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.Grantee = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Grantee(")
        append("granteeIdentifier=$granteeIdentifier,")
        append("granteeType=$granteeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = granteeIdentifier?.hashCode() ?: 0
        result = 31 * result + (granteeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Grantee

        if (granteeIdentifier != other.granteeIdentifier) return false
        if (granteeType != other.granteeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.Grantee = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the `Grantee`. If the grantee type is `IAM`, the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`. You can obtain this UUID from your Amazon Web Services IAM Identity Center instance.
         */
        public var granteeIdentifier: kotlin.String? = null
        /**
         * The type of the grantee to which access has been granted. It can be one of the following values:
         * + `IAM` - An IAM user or role.
         * + `DIRECTORY_USER` - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
         * + `DIRECTORY_GROUP` - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.
         */
        public var granteeType: aws.sdk.kotlin.services.s3control.model.GranteeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.Grantee) : this() {
            this.granteeIdentifier = x.granteeIdentifier
            this.granteeType = x.granteeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.Grantee = Grantee(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
