// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Web Services Security Token Service temporary credential that S3 Access Grants vends to grantees and client applications.
 */
public class Credentials private constructor(builder: Builder) {
    /**
     * The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client applications.
     */
    public val expiration: aws.smithy.kotlin.runtime.time.Instant? = builder.expiration
    /**
     * The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     */
    public val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     */
    public val sessionToken: kotlin.String? = builder.sessionToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.Credentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Credentials(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (sessionToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Credentials

        if (accessKeyId != other.accessKeyId) return false
        if (expiration != other.expiration) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.Credentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client applications.
         */
        public var expiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.Credentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.expiration = x.expiration
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.Credentials = Credentials(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
