// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * The configuration options of the S3 Access Grants location. It contains the `S3SubPrefix` field. The grant scope, the data to which you are granting access, is the result of appending the `Subprefix` field to the scope of the registered location.
 */
public class AccessGrantsLocationConfiguration private constructor(builder: Builder) {
    /**
     * The `S3SubPrefix` is appended to the location scope creating the grant scope. Use this field to narrow the scope of the grant to a subset of the location scope. This field is required if the location scope is the default location `s3://` because you cannot create a grant for all of your S3 data in the Region and must narrow the scope. For example, if the location scope is the default location `s3://`, the `S3SubPrefx` can be a <bucket-name>&#47;*, so the full grant scope path would be `s3://<bucket-name>&#47;*`. Or the `S3SubPrefx` can be `<bucket-name>/<prefix-name>*`, so the full grant scope path would be or `s3://<bucket-name>/<prefix-name>*`.
     *
     * If the `S3SubPrefix` includes a prefix, append the wildcard character `*` after the prefix to indicate that you want to include all object key names in the bucket that start with that prefix.
     */
    public val s3SubPrefix: kotlin.String? = builder.s3SubPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessGrantsLocationConfiguration(")
        append("s3SubPrefix=$s3SubPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3SubPrefix?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessGrantsLocationConfiguration

        if (s3SubPrefix != other.s3SubPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `S3SubPrefix` is appended to the location scope creating the grant scope. Use this field to narrow the scope of the grant to a subset of the location scope. This field is required if the location scope is the default location `s3://` because you cannot create a grant for all of your S3 data in the Region and must narrow the scope. For example, if the location scope is the default location `s3://`, the `S3SubPrefx` can be a <bucket-name>&#47;*, so the full grant scope path would be `s3://<bucket-name>&#47;*`. Or the `S3SubPrefx` can be `<bucket-name>/<prefix-name>*`, so the full grant scope path would be or `s3://<bucket-name>/<prefix-name>*`.
         *
         * If the `S3SubPrefix` includes a prefix, append the wildcard character `*` after the prefix to indicate that you want to include all object key names in the bucket that start with that prefix.
         */
        public var s3SubPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration) : this() {
            this.s3SubPrefix = x.s3SubPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration = AccessGrantsLocationConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
