// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.PutJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.S3Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutJobTaggingOperationSerializer: HttpSerialize<PutJobTaggingRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutJobTaggingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.jobId) { "jobId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20180820"))
                add(PercentEncoding.Path.encode("jobs"))
                add(PercentEncoding.SmithyLabel.encode("${input.jobId}"))
                add(PercentEncoding.Path.encode("tagging"))
            }
        }

        builder.headers {
            if (input.accountId?.isNotEmpty() == true) append("x-amz-account-id", input.accountId)
        }

        val payload = serializePutJobTaggingOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializePutJobTaggingOperationBody(context: ExecutionContext, input: PutJobTaggingRequest): ByteArray {
    val serializer = XmlSerializer()
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("PutJobTaggingRequest"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeS3TagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
