// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsLocationResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetAccessGrantsLocationOperationDeserializer: HttpDeserialize<GetAccessGrantsLocationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAccessGrantsLocationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccessGrantsLocationError(context, call)
        }
        val builder = GetAccessGrantsLocationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccessGrantsLocationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAccessGrantsLocationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessGrantsLocationOperationBody(builder: GetAccessGrantsLocationResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ACCESSGRANTSLOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessGrantsLocationArn"))
    val ACCESSGRANTSLOCATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessGrantsLocationId"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreatedAt"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("IAMRoleArn"))
    val LOCATIONSCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("LocationScope"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetAccessGrantsLocationResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(ACCESSGRANTSLOCATIONARN_DESCRIPTOR)
        field(ACCESSGRANTSLOCATIONID_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(LOCATIONSCOPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSGRANTSLOCATIONARN_DESCRIPTOR.index -> builder.accessGrantsLocationArn = deserializeString()
                ACCESSGRANTSLOCATIONID_DESCRIPTOR.index -> builder.accessGrantsLocationId = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                IAMROLEARN_DESCRIPTOR.index -> builder.iamRoleArn = deserializeString()
                LOCATIONSCOPE_DESCRIPTOR.index -> builder.locationScope = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
