// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateAccessGrantsLocationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the registered location that you are updating.
     */
    public val accessGrantsLocationArn: kotlin.String? = builder.accessGrantsLocationArn
    /**
     * The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
     */
    public val accessGrantsLocationId: kotlin.String? = builder.accessGrantsLocationId
    /**
     * The date and time when you registered the location.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) of the IAM role of the registered location. S3 Access Grants assumes this role to manage access to the registered location.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The S3 URI path of the location that you are updating. You cannot update the scope of the registered location. The location scope can be the default S3 location `s3://`, the S3 path to a bucket `s3://<bucket>`, or the S3 path to a bucket and prefix `s3://<bucket>/<prefix>`.
     */
    public val locationScope: kotlin.String? = builder.locationScope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccessGrantsLocationResponse(")
        append("accessGrantsLocationArn=$accessGrantsLocationArn,")
        append("accessGrantsLocationId=$accessGrantsLocationId,")
        append("createdAt=$createdAt,")
        append("iamRoleArn=$iamRoleArn,")
        append("locationScope=$locationScope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessGrantsLocationArn?.hashCode() ?: 0
        result = 31 * result + (accessGrantsLocationId?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (locationScope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAccessGrantsLocationResponse

        if (accessGrantsLocationArn != other.accessGrantsLocationArn) return false
        if (accessGrantsLocationId != other.accessGrantsLocationId) return false
        if (createdAt != other.createdAt) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (locationScope != other.locationScope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the registered location that you are updating.
         */
        public var accessGrantsLocationArn: kotlin.String? = null
        /**
         * The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
         */
        public var accessGrantsLocationId: kotlin.String? = null
        /**
         * The date and time when you registered the location.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role of the registered location. S3 Access Grants assumes this role to manage access to the registered location.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The S3 URI path of the location that you are updating. You cannot update the scope of the registered location. The location scope can be the default S3 location `s3://`, the S3 path to a bucket `s3://<bucket>`, or the S3 path to a bucket and prefix `s3://<bucket>/<prefix>`.
         */
        public var locationScope: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationResponse) : this() {
            this.accessGrantsLocationArn = x.accessGrantsLocationArn
            this.accessGrantsLocationId = x.accessGrantsLocationId
            this.createdAt = x.createdAt
            this.iamRoleArn = x.iamRoleArn
            this.locationScope = x.locationScope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationResponse = UpdateAccessGrantsLocationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
