// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container that specifies S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
 *
 * This is not supported by Amazon S3 on Outposts buckets.
 */
public class ReplicationTime private constructor(builder: Builder) {
    /**
     * Specifies whether S3 Replication Time Control (S3 RTC) is enabled.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.ReplicationTimeStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A container that specifies the time by which replication should be complete for all objects and operations on objects.
     */
    public val time: aws.sdk.kotlin.services.s3control.model.ReplicationTimeValue? = builder.time

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ReplicationTime = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationTime(")
        append("status=$status,")
        append("time=$time")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status.hashCode()
        result = 31 * result + (time?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationTime

        if (status != other.status) return false
        if (time != other.time) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ReplicationTime = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether S3 Replication Time Control (S3 RTC) is enabled.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.ReplicationTimeStatus? = null
        /**
         * A container that specifies the time by which replication should be complete for all objects and operations on objects.
         */
        public var time: aws.sdk.kotlin.services.s3control.model.ReplicationTimeValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ReplicationTime) : this() {
            this.status = x.status
            this.time = x.time
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ReplicationTime = ReplicationTime(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ReplicationTimeValue] inside the given [block]
         */
        public fun time(block: aws.sdk.kotlin.services.s3control.model.ReplicationTimeValue.Builder.() -> kotlin.Unit) {
            this.time = aws.sdk.kotlin.services.s3control.model.ReplicationTimeValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (status == null) status = ReplicationTimeStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
