// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Specifies which S3 on Outposts objects to replicate and where to store the replicas.
 */
public class ReplicationRule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the access point for the source Outposts bucket that you want S3 on Outposts to replicate the objects from.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Specifies whether S3 on Outposts replicates delete markers. If you specify a `Filter` element in your replication configuration, you must also include a `DeleteMarkerReplication` element. If your `Filter` includes a `Tag` element, the `DeleteMarkerReplication` element's `Status` child element must be set to `Disabled`, because S3 on Outposts doesn't support replicating delete markers for tag-based rules.
     *
     * For more information about delete marker replication, see [How delete operations affect replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated) in the *Amazon S3 User Guide*.
     */
    public val deleteMarkerReplication: aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication? = builder.deleteMarkerReplication
    /**
     * A container for information about the replication destination and its configurations.
     */
    public val destination: aws.sdk.kotlin.services.s3control.model.Destination? = builder.destination
    /**
     * An optional configuration to replicate existing source bucket objects.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val existingObjectReplication: aws.sdk.kotlin.services.s3control.model.ExistingObjectReplication? = builder.existingObjectReplication
    /**
     * A filter that identifies the subset of objects to which the replication rule applies. A `Filter` element must specify exactly one `Prefix`, `Tag`, or `And` child element.
     */
    public val filter: aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter? = builder.filter
    /**
     * A unique identifier for the rule. The maximum value is 255 characters.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in an Outposts bucket, specify an empty string.
     *
     * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The priority indicates which rule has precedence whenever two or more replication rules conflict. S3 on Outposts attempts to replicate objects according to all replication rules. However, if there are two or more rules with the same destination Outposts bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority.
     *
     * For more information, see [Creating replication rules on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-between-outposts.html) in the *Amazon S3 User Guide*.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * A container that describes additional filters for identifying the source Outposts objects that you want to replicate. You can choose to enable or disable the replication of these objects.
     */
    public val sourceSelectionCriteria: aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria? = builder.sourceSelectionCriteria
    /**
     * Specifies whether the rule is enabled.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.ReplicationRuleStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ReplicationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationRule(")
        append("bucket=$bucket,")
        append("deleteMarkerReplication=$deleteMarkerReplication,")
        append("destination=$destination,")
        append("existingObjectReplication=$existingObjectReplication,")
        append("filter=$filter,")
        append("id=$id,")
        append("prefix=$prefix,")
        append("priority=$priority,")
        append("sourceSelectionCriteria=$sourceSelectionCriteria,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (deleteMarkerReplication?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (existingObjectReplication?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (sourceSelectionCriteria?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationRule

        if (bucket != other.bucket) return false
        if (deleteMarkerReplication != other.deleteMarkerReplication) return false
        if (destination != other.destination) return false
        if (existingObjectReplication != other.existingObjectReplication) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (prefix != other.prefix) return false
        if (priority != other.priority) return false
        if (sourceSelectionCriteria != other.sourceSelectionCriteria) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ReplicationRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the access point for the source Outposts bucket that you want S3 on Outposts to replicate the objects from.
         */
        public var bucket: kotlin.String? = null
        /**
         * Specifies whether S3 on Outposts replicates delete markers. If you specify a `Filter` element in your replication configuration, you must also include a `DeleteMarkerReplication` element. If your `Filter` includes a `Tag` element, the `DeleteMarkerReplication` element's `Status` child element must be set to `Disabled`, because S3 on Outposts doesn't support replicating delete markers for tag-based rules.
         *
         * For more information about delete marker replication, see [How delete operations affect replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated) in the *Amazon S3 User Guide*.
         */
        public var deleteMarkerReplication: aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication? = null
        /**
         * A container for information about the replication destination and its configurations.
         */
        public var destination: aws.sdk.kotlin.services.s3control.model.Destination? = null
        /**
         * An optional configuration to replicate existing source bucket objects.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var existingObjectReplication: aws.sdk.kotlin.services.s3control.model.ExistingObjectReplication? = null
        /**
         * A filter that identifies the subset of objects to which the replication rule applies. A `Filter` element must specify exactly one `Prefix`, `Tag`, or `And` child element.
         */
        public var filter: aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter? = null
        /**
         * A unique identifier for the rule. The maximum value is 255 characters.
         */
        public var id: kotlin.String? = null
        /**
         * An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in an Outposts bucket, specify an empty string.
         *
         * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var prefix: kotlin.String? = null
        /**
         * The priority indicates which rule has precedence whenever two or more replication rules conflict. S3 on Outposts attempts to replicate objects according to all replication rules. However, if there are two or more rules with the same destination Outposts bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority.
         *
         * For more information, see [Creating replication rules on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-between-outposts.html) in the *Amazon S3 User Guide*.
         */
        public var priority: kotlin.Int? = null
        /**
         * A container that describes additional filters for identifying the source Outposts objects that you want to replicate. You can choose to enable or disable the replication of these objects.
         */
        public var sourceSelectionCriteria: aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria? = null
        /**
         * Specifies whether the rule is enabled.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.ReplicationRuleStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ReplicationRule) : this() {
            this.bucket = x.bucket
            this.deleteMarkerReplication = x.deleteMarkerReplication
            this.destination = x.destination
            this.existingObjectReplication = x.existingObjectReplication
            this.filter = x.filter
            this.id = x.id
            this.prefix = x.prefix
            this.priority = x.priority
            this.sourceSelectionCriteria = x.sourceSelectionCriteria
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ReplicationRule = ReplicationRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication] inside the given [block]
         */
        public fun deleteMarkerReplication(block: aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication.Builder.() -> kotlin.Unit) {
            this.deleteMarkerReplication = aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.s3control.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.s3control.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ExistingObjectReplication] inside the given [block]
         */
        public fun existingObjectReplication(block: aws.sdk.kotlin.services.s3control.model.ExistingObjectReplication.Builder.() -> kotlin.Unit) {
            this.existingObjectReplication = aws.sdk.kotlin.services.s3control.model.ExistingObjectReplication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria] inside the given [block]
         */
        public fun sourceSelectionCriteria(block: aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria.Builder.() -> kotlin.Unit) {
            this.sourceSelectionCriteria = aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (status == null) status = ReplicationRuleStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
