// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Contains the configuration parameters for a `Lambda Invoke` operation.
 */
public class LambdaInvokeOperation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.
     */
    public val functionArn: kotlin.String? = builder.functionArn
    /**
     * Specifies the schema version for the payload that Batch Operations sends when invoking an Lambda function. Version `1.0` is the default. Version `2.0` is required when you use Batch Operations to invoke Lambda functions that act on directory buckets, or if you need to specify `UserArguments`. For more information, see [Using Lambda with Amazon S3 Batch Operations and Amazon S3 Express One Zone](https://aws.amazon.com/blogs/storage/using-lambda-with-s3-batch-operations-and-s3-express-one-zone/) in the *Amazon Web Services Storage Blog*.
     *
     * Ensure that your Lambda function code expects `InvocationSchemaVersion`**2.0** and uses bucket name rather than bucket ARN. If the `InvocationSchemaVersion` does not match what your Lambda function expects, your function might not work as expected.
     *
     * **Directory buckets** - To initiate Amazon Web Services Lambda function to perform custom actions on objects in directory buckets, you must specify `2.0`.
     */
    public val invocationSchemaVersion: kotlin.String? = builder.invocationSchemaVersion
    /**
     * Key-value pairs that are passed in the payload that Batch Operations sends when invoking an Lambda function. You must specify `InvocationSchemaVersion`**2.0** for `LambdaInvoke` operations that include `UserArguments`. For more information, see [Using Lambda with Amazon S3 Batch Operations and Amazon S3 Express One Zone](https://aws.amazon.com/blogs/storage/using-lambda-with-s3-batch-operations-and-s3-express-one-zone/) in the *Amazon Web Services Storage Blog*.
     */
    public val userArguments: Map<String, String>? = builder.userArguments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaInvokeOperation(")
        append("functionArn=$functionArn,")
        append("invocationSchemaVersion=$invocationSchemaVersion,")
        append("userArguments=$userArguments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionArn?.hashCode() ?: 0
        result = 31 * result + (invocationSchemaVersion?.hashCode() ?: 0)
        result = 31 * result + (userArguments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaInvokeOperation

        if (functionArn != other.functionArn) return false
        if (invocationSchemaVersion != other.invocationSchemaVersion) return false
        if (userArguments != other.userArguments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.
         */
        public var functionArn: kotlin.String? = null
        /**
         * Specifies the schema version for the payload that Batch Operations sends when invoking an Lambda function. Version `1.0` is the default. Version `2.0` is required when you use Batch Operations to invoke Lambda functions that act on directory buckets, or if you need to specify `UserArguments`. For more information, see [Using Lambda with Amazon S3 Batch Operations and Amazon S3 Express One Zone](https://aws.amazon.com/blogs/storage/using-lambda-with-s3-batch-operations-and-s3-express-one-zone/) in the *Amazon Web Services Storage Blog*.
         *
         * Ensure that your Lambda function code expects `InvocationSchemaVersion`**2.0** and uses bucket name rather than bucket ARN. If the `InvocationSchemaVersion` does not match what your Lambda function expects, your function might not work as expected.
         *
         * **Directory buckets** - To initiate Amazon Web Services Lambda function to perform custom actions on objects in directory buckets, you must specify `2.0`.
         */
        public var invocationSchemaVersion: kotlin.String? = null
        /**
         * Key-value pairs that are passed in the payload that Batch Operations sends when invoking an Lambda function. You must specify `InvocationSchemaVersion`**2.0** for `LambdaInvoke` operations that include `UserArguments`. For more information, see [Using Lambda with Amazon S3 Batch Operations and Amazon S3 Express One Zone](https://aws.amazon.com/blogs/storage/using-lambda-with-s3-batch-operations-and-s3-express-one-zone/) in the *Amazon Web Services Storage Blog*.
         */
        public var userArguments: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation) : this() {
            this.functionArn = x.functionArn
            this.invocationSchemaVersion = x.invocationSchemaVersion
            this.userArguments = x.userArguments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation = LambdaInvokeOperation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
