// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The filter used to describe a set of objects for the job's manifest.
 */
public class JobManifestGeneratorFilter private constructor(builder: Builder) {
    /**
     * If provided, the generated manifest includes only source bucket objects that were created after this time.
     */
    public val createdAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAfter
    /**
     * If provided, the generated manifest includes only source bucket objects that were created before this time.
     */
    public val createdBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.createdBefore
    /**
     * Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.
     */
    public val eligibleForReplication: kotlin.Boolean? = builder.eligibleForReplication
    /**
     * If provided, the generated manifest includes only source bucket objects whose object keys match the string constraints specified for `MatchAnyPrefix`, `MatchAnySuffix`, and `MatchAnySubstring`.
     */
    public val keyNameConstraint: aws.sdk.kotlin.services.s3control.model.KeyNameConstraint? = builder.keyNameConstraint
    /**
     * If provided, the generated manifest includes only source bucket objects that are stored with the specified storage class.
     */
    public val matchAnyStorageClass: List<S3StorageClass>? = builder.matchAnyStorageClass
    /**
     * If provided, the generated manifest includes only source bucket objects that have one of the specified Replication statuses.
     */
    public val objectReplicationStatuses: List<ReplicationStatus>? = builder.objectReplicationStatuses
    /**
     * If provided, the generated manifest includes only source bucket objects whose file size is greater than the specified number of bytes.
     */
    public val objectSizeGreaterThanBytes: kotlin.Long? = builder.objectSizeGreaterThanBytes
    /**
     * If provided, the generated manifest includes only source bucket objects whose file size is less than the specified number of bytes.
     */
    public val objectSizeLessThanBytes: kotlin.Long? = builder.objectSizeLessThanBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobManifestGeneratorFilter(")
        append("createdAfter=$createdAfter,")
        append("createdBefore=$createdBefore,")
        append("eligibleForReplication=$eligibleForReplication,")
        append("keyNameConstraint=$keyNameConstraint,")
        append("matchAnyStorageClass=$matchAnyStorageClass,")
        append("objectReplicationStatuses=$objectReplicationStatuses,")
        append("objectSizeGreaterThanBytes=$objectSizeGreaterThanBytes,")
        append("objectSizeLessThanBytes=$objectSizeLessThanBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAfter?.hashCode() ?: 0
        result = 31 * result + (createdBefore?.hashCode() ?: 0)
        result = 31 * result + (eligibleForReplication?.hashCode() ?: 0)
        result = 31 * result + (keyNameConstraint?.hashCode() ?: 0)
        result = 31 * result + (matchAnyStorageClass?.hashCode() ?: 0)
        result = 31 * result + (objectReplicationStatuses?.hashCode() ?: 0)
        result = 31 * result + (objectSizeGreaterThanBytes?.hashCode() ?: 0)
        result = 31 * result + (objectSizeLessThanBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobManifestGeneratorFilter

        if (createdAfter != other.createdAfter) return false
        if (createdBefore != other.createdBefore) return false
        if (eligibleForReplication != other.eligibleForReplication) return false
        if (keyNameConstraint != other.keyNameConstraint) return false
        if (matchAnyStorageClass != other.matchAnyStorageClass) return false
        if (objectReplicationStatuses != other.objectReplicationStatuses) return false
        if (objectSizeGreaterThanBytes != other.objectSizeGreaterThanBytes) return false
        if (objectSizeLessThanBytes != other.objectSizeLessThanBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If provided, the generated manifest includes only source bucket objects that were created after this time.
         */
        public var createdAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If provided, the generated manifest includes only source bucket objects that were created before this time.
         */
        public var createdBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.
         */
        public var eligibleForReplication: kotlin.Boolean? = null
        /**
         * If provided, the generated manifest includes only source bucket objects whose object keys match the string constraints specified for `MatchAnyPrefix`, `MatchAnySuffix`, and `MatchAnySubstring`.
         */
        public var keyNameConstraint: aws.sdk.kotlin.services.s3control.model.KeyNameConstraint? = null
        /**
         * If provided, the generated manifest includes only source bucket objects that are stored with the specified storage class.
         */
        public var matchAnyStorageClass: List<S3StorageClass>? = null
        /**
         * If provided, the generated manifest includes only source bucket objects that have one of the specified Replication statuses.
         */
        public var objectReplicationStatuses: List<ReplicationStatus>? = null
        /**
         * If provided, the generated manifest includes only source bucket objects whose file size is greater than the specified number of bytes.
         */
        public var objectSizeGreaterThanBytes: kotlin.Long? = null
        /**
         * If provided, the generated manifest includes only source bucket objects whose file size is less than the specified number of bytes.
         */
        public var objectSizeLessThanBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter) : this() {
            this.createdAfter = x.createdAfter
            this.createdBefore = x.createdBefore
            this.eligibleForReplication = x.eligibleForReplication
            this.keyNameConstraint = x.keyNameConstraint
            this.matchAnyStorageClass = x.matchAnyStorageClass
            this.objectReplicationStatuses = x.objectReplicationStatuses
            this.objectSizeGreaterThanBytes = x.objectSizeGreaterThanBytes
            this.objectSizeLessThanBytes = x.objectSizeLessThanBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter = JobManifestGeneratorFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.KeyNameConstraint] inside the given [block]
         */
        public fun keyNameConstraint(block: aws.sdk.kotlin.services.s3control.model.KeyNameConstraint.Builder.() -> kotlin.Unit) {
            this.keyNameConstraint = aws.sdk.kotlin.services.s3control.model.KeyNameConstraint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
