// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



public class GetDataAccessRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that is making this request.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to the grantee or client application. The default value is 1 hour, but the grantee can specify a range from 900 seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher than this maximum, the operation fails.
     */
    public val durationSeconds: kotlin.Int? = builder.durationSeconds
    /**
     * The type of permission granted to your S3 data, which can be set to one of the following values:
     * + `READ` – Grant read-only access to the S3 data.
     * + `WRITE` – Grant write-only access to the S3 data.
     * + `READWRITE` – Grant both read and write access to the S3 data.
     */
    public val permission: aws.sdk.kotlin.services.s3control.model.Permission? = builder.permission
    /**
     * The scope of the temporary access credential that S3 Access Grants vends to the grantee or client application.
     * + `Default` – The scope of the returned temporary access token is the scope of the grant that is closest to the target scope.
     * + `Minimal` – The scope of the returned temporary access token is the same as the requested target scope as long as the requested scope is the same as or a subset of the grant scope.
     */
    public val privilege: aws.sdk.kotlin.services.s3control.model.Privilege? = builder.privilege
    /**
     * The S3 URI path of the data to which you are requesting temporary access credentials. If the requesting account has an access grant for this data, S3 Access Grants vends temporary access credentials in the response.
     */
    public val target: kotlin.String? = builder.target
    /**
     * The type of `Target`. The only possible value is `Object`. Pass this value if the target data that you would like to access is a path to an object. Do not pass this value if the target data is a bucket or a bucket and a prefix.
     */
    public val targetType: aws.sdk.kotlin.services.s3control.model.S3PrefixType? = builder.targetType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.GetDataAccessRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDataAccessRequest(")
        append("accountId=$accountId,")
        append("durationSeconds=$durationSeconds,")
        append("permission=$permission,")
        append("privilege=$privilege,")
        append("target=$target,")
        append("targetType=$targetType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (durationSeconds ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        result = 31 * result + (privilege?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDataAccessRequest

        if (accountId != other.accountId) return false
        if (durationSeconds != other.durationSeconds) return false
        if (permission != other.permission) return false
        if (privilege != other.privilege) return false
        if (target != other.target) return false
        if (targetType != other.targetType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.GetDataAccessRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account that is making this request.
         */
        public var accountId: kotlin.String? = null
        /**
         * The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to the grantee or client application. The default value is 1 hour, but the grantee can specify a range from 900 seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher than this maximum, the operation fails.
         */
        public var durationSeconds: kotlin.Int? = null
        /**
         * The type of permission granted to your S3 data, which can be set to one of the following values:
         * + `READ` – Grant read-only access to the S3 data.
         * + `WRITE` – Grant write-only access to the S3 data.
         * + `READWRITE` – Grant both read and write access to the S3 data.
         */
        public var permission: aws.sdk.kotlin.services.s3control.model.Permission? = null
        /**
         * The scope of the temporary access credential that S3 Access Grants vends to the grantee or client application.
         * + `Default` – The scope of the returned temporary access token is the scope of the grant that is closest to the target scope.
         * + `Minimal` – The scope of the returned temporary access token is the same as the requested target scope as long as the requested scope is the same as or a subset of the grant scope.
         */
        public var privilege: aws.sdk.kotlin.services.s3control.model.Privilege? = null
        /**
         * The S3 URI path of the data to which you are requesting temporary access credentials. If the requesting account has an access grant for this data, S3 Access Grants vends temporary access credentials in the response.
         */
        public var target: kotlin.String? = null
        /**
         * The type of `Target`. The only possible value is `Object`. Pass this value if the target data that you would like to access is a path to an object. Do not pass this value if the target data is a bucket or a bucket and a prefix.
         */
        public var targetType: aws.sdk.kotlin.services.s3control.model.S3PrefixType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.GetDataAccessRequest) : this() {
            this.accountId = x.accountId
            this.durationSeconds = x.durationSeconds
            this.permission = x.permission
            this.privilege = x.privilege
            this.target = x.target
            this.targetType = x.targetType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.GetDataAccessRequest = GetDataAccessRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
